/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.common.shared.model.ServiceException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class NewsInternalApiConnector {
    private static final Logger LOG = LoggerFactory.getLogger(NewsInternalApiConnector.class);
    private final String _newsInternalUrl;
    private final RestOperations _restOperations;

    @Autowired
    public NewsInternalApiConnector(@Value(value="${just-news.internal.url}") String newsInternalUrl, @Qualifier(value="defaultRestTemplate") RestOperations restOperations) {
        this._newsInternalUrl = newsInternalUrl;
        this._restOperations = restOperations;
    }

    public void republishAllPermissions() {
        try {
            LOG.debug("Send POST request to republish news permissions.");
            this._restOperations.postForLocation(this._newsInternalUrl + "/republish/permissions", null, new Object[0]);
        }
        catch (RestClientException exception) {
            LOG.error("Republish news permissions failed!", (Throwable)exception);
        }
    }

    public void reindex() {
        try {
            LOG.debug("Send POST request to reindex news data.");
            this._restOperations.postForLocation(this._newsInternalUrl + "/search/reindex", null, new Object[0]);
        }
        catch (RestClientException exception) {
            LOG.error("Reindex news permissions failed!", (Throwable)exception);
        }
    }

    public boolean isAvailable() {
        try {
            this.checkHealth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkHealth() {
        try {
            this._restOperations.getForEntity(this._newsInternalUrl + "/monitoring/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("News-Service health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString() + ")");
        }
    }
}

