/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mybatis;

import de.justsoftware.onx.newszoom.integration.persistence.mapper.NewsZoomSettingsMapper;
import de.justsoftware.onx.tenantdesign.persistence.TenantThemeMapper;
import de.justsoftware.onx.tenantinvitation.persistence.TenantInvitationMapper;
import de.justsoftware.polls.persistence.mapper.PollMapper;
import de.justsoftware.toolbox.mybatis.AutoFlushExecutor;
import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import de.justsoftware.toolbox.mybatis.type.AbstractDriverSpecificTypeHandler;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@DependsOn(value={"liquibase"})
@Service(value="sqlSessionFactoryBean")
public class SqlSessionFactoryBean
extends org.mybatis.spring.SqlSessionFactoryBean {
    public static final String SQL_SESSION_FACTORY = "sqlSessionFactoryBean";
    private final SupportedJdbcDriver _driver;
    private final int _batchSize;

    @Autowired
    public SqlSessionFactoryBean(DataSource dataSource, @Value(value="${JDBC.ConnectionURL}") String jdbcConnectionUrl, @Value(value="${just.jdbc.batchsize:500}") int batchSize) {
        this._batchSize = batchSize;
        this._driver = SupportedJdbcDriver.driverFromUrl((String)jdbcConnectionUrl);
        this.setDataSource(dataSource);
        this.setTypeHandlersPackage("de.justsoftware.onx.mybatis.typehandler");
        this.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
        this.setSqlSessionFactoryBuilder(new SqlSessionFactoryBuilderExtension());
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        AbstractDriverSpecificTypeHandler.setJdbcDriver((SupportedJdbcDriver)this._driver);
        SqlSessionFactory sqlSessionFactory = super.buildSqlSessionFactory();
        AbstractDriverSpecificTypeHandler.setJdbcDriver(null);
        return sqlSessionFactory;
    }

    @ParametersAreNonnullByDefault
    private final class SqlSessionFactoryBuilderExtension
    extends SqlSessionFactoryBuilder {
        private SqlSessionFactoryBuilderExtension() {
        }

        public SqlSessionFactory build(Configuration config) {
            config.setDefaultExecutorType(ExecutorType.BATCH);
            config.setJdbcTypeForNull(this.jdbcTypeForNull(SqlSessionFactoryBean.this._driver));
            config.setDatabaseId(SqlSessionFactoryBean.this._driver.name());
            config.setCacheEnabled(false);
            config.addMapper(NewsZoomSettingsMapper.class);
            config.addMapper(TenantThemeMapper.class);
            config.addMapper(PollMapper.class);
            config.addMapper(TenantInvitationMapper.class);
            config.addInterceptor(new Interceptor(){

                public void setProperties(Properties properties) {
                }

                public Object plugin(Object target) {
                    if (target instanceof Executor) {
                        return new AutoFlushExecutor((Executor)target, SqlSessionFactoryBean.this._batchSize);
                    }
                    return target;
                }

                public Object intercept(Invocation invocation) {
                    throw new UnsupportedOperationException();
                }
            });
            return super.build(config);
        }

        @Nonnull
        private JdbcType jdbcTypeForNull(SupportedJdbcDriver driver) {
            switch (driver) {
                case ORACLE: {
                    return JdbcType.NULL;
                }
                case POSTGRES: {
                    return JdbcType.OTHER;
                }
            }
            return JdbcType.OTHER;
        }
    }
}

