/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersionSection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MultiWikiVersionSection
implements IMultiWikiVersionSection,
Item<MultiWikiVersionSectionId> {
    private final MultiWikiVersionSectionId _id;
    private final MultiWikiVersionId _parentId;
    private final MultiWikiSectionId _sectionId;
    private final String _headline;
    private final String _text;
    private final int _order;
    private final ImmutableSet<String> _selectedRolesAllowedToRead;

    public MultiWikiVersionSection(@Nonnull IMultiWikiVersionSection multiWikiSection) {
        this._id = multiWikiSection.getId();
        this._parentId = multiWikiSection.getParentId();
        this._sectionId = multiWikiSection.getSectionId();
        this._headline = multiWikiSection.getHeadline();
        this._text = multiWikiSection.getText();
        this._order = multiWikiSection.getOrder();
        this._selectedRolesAllowedToRead = multiWikiSection.getSelectedRolesAllowedToRead();
    }

    public MultiWikiVersionSection(@Nonnull IMultiWikiVersionSection multiWikiSection, @Nonnull ImmutableSet<String> selectedRolesAllowedToRead) {
        this._id = multiWikiSection.getId();
        this._parentId = multiWikiSection.getParentId();
        this._sectionId = multiWikiSection.getSectionId();
        this._headline = multiWikiSection.getHeadline();
        this._text = multiWikiSection.getText();
        this._order = multiWikiSection.getOrder();
        this._selectedRolesAllowedToRead = selectedRolesAllowedToRead;
    }

    @CheckForNull
    public static MultiWikiVersionSection valueOf(@Nullable IMultiWikiVersionSection multiWikiSection) {
        return multiWikiSection == null ? null : new MultiWikiVersionSection(multiWikiSection);
    }

    @Override
    public MultiWikiVersionSectionId getId() {
        return this._id;
    }

    @Override
    @Nonnull
    public MultiWikiVersionId getParentId() {
        return this._parentId;
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.MULTI_WIKI;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String getHeadline() {
        return this._headline;
    }

    @Override
    public String getText() {
        return this._text;
    }

    @Override
    public MultiWikiSectionId getSectionId() {
        return this._sectionId;
    }

    @Override
    public int getOrder() {
        return this._order;
    }

    @Override
    public ImmutableSet<String> getSelectedRolesAllowedToRead() {
        return this._selectedRolesAllowedToRead;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).add("sectionId", (Object)this._sectionId).add("headline", (Object)this._headline).add("text", (Object)this._text).add("order", this._order).add("selectedRolesAllowedToRead", this._selectedRolesAllowedToRead == null ? null : Integer.valueOf(this._selectedRolesAllowedToRead.size())).toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiWikiVersionSection)) {
            return false;
        }
        MultiWikiVersionSection other = (MultiWikiVersionSection)obj;
        return this.getId().equals(other.getId());
    }
}

