/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiTocType;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MultiWikiClientModel
implements ModuleData {
    private static final long serialVersionUID = 3L;
    private MultiWikiId _id;
    private MultiWikiVersionId _versionId;
    private AlbumId _albumId;
    private ImmutableList<MultiWikiSectionClientModel> _sections;
    private ImmutableSet<Action> _permissions;
    private int _maxSections;
    private MultiWikiTocType _tocType;
    private ImmutableList<AuthorityModel> _rolesForSectionRead;
    private ImmutableList<AuthorityModel> _rolesForViewAs;
    private String _viewedAsRole;

    @Deprecated
    public MultiWikiClientModel() {
    }

    public MultiWikiClientModel(@Nonnull MultiWikiId id, @Nonnull MultiWikiVersionId versionId, @Nonnull AlbumId albumId, @Nonnull ImmutableList<MultiWikiSectionClientModel> sections, @Nonnull ImmutableSet<Action> permissions, int maxSections, @Nonnull MultiWikiTocType tocType, @Nonnull ImmutableList<AuthorityModel> rolesForSectionRead, @Nonnull ImmutableList<AuthorityModel> rolesForViewAs, @Nullable String viewedAsRole) {
        this._id = id;
        this._versionId = versionId;
        this._albumId = albumId;
        this._sections = sections;
        this._permissions = permissions;
        this._maxSections = maxSections;
        this._tocType = tocType;
        this._rolesForSectionRead = rolesForSectionRead;
        this._rolesForViewAs = rolesForViewAs;
        this._viewedAsRole = viewedAsRole;
    }

    @Nonnull
    public ImmutableList<MultiWikiSectionClientModel> getSections() {
        return this._sections;
    }

    @Nonnull
    public ImmutableSet<Action> getPermissions() {
        return this._permissions;
    }

    @Nonnull
    public AlbumId getAlbumId() {
        return this._albumId;
    }

    @Nonnull
    public MultiWikiId getId() {
        return this._id;
    }

    @Nonnull
    public MultiWikiVersionId getVersionId() {
        return this._versionId;
    }

    public void setVersionId(@Nonnull MultiWikiVersionId versionId) {
        this._versionId = versionId;
    }

    public int getMaxSections() {
        return this._maxSections;
    }

    @Nonnull
    public MultiWikiTocType getTocType() {
        return this._tocType;
    }

    @Nonnull
    public ImmutableList<AuthorityModel> getRolesForSectionRead() {
        return this._rolesForSectionRead;
    }

    @Nonnull
    public ImmutableList<String> getDefaultRolesForSectionRead() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AuthorityModel availableRole : this._rolesForSectionRead) {
            if (!availableRole.isDefault() && !availableRole.isForced()) continue;
            result.add((Object)availableRole.getAuthority());
        }
        return result.build().asList();
    }

    @Nonnull
    public ImmutableList<AuthorityModel> getRolesForViewAs() {
        return this._rolesForViewAs;
    }

    @CheckForNull
    public String getViewedAsRole() {
        return this._viewedAsRole;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("versionId", (Object)this._versionId).add("albumId", (Object)this._albumId).add("sections", this._sections == null ? null : Integer.valueOf(this._sections.size())).add("permissions", this._permissions == null ? null : Integer.valueOf(this._permissions.size())).add("maxSections", this._maxSections).add("tocType", (Object)this._tocType).add("availableRolesAllowedToRead", this._rolesForSectionRead == null ? null : Integer.valueOf(this._rolesForSectionRead.size())).add("availableRolesAllowedToRead", this._rolesForSectionRead == null ? null : Integer.valueOf(this._rolesForViewAs.size())).add("viewedAsRole", (Object)this._viewedAsRole).toString();
    }

    @Override
    public boolean hasData() {
        return true;
    }
}

