/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.common.business.AntiSamyService;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.ConcurrentUpdateException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.model.right.StaticRight;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.multiwiki.business.MultiWikiReadDataService;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.business.MultiWikiWriteDataService;
import de.justsoftware.onx.multiwiki.business.events.MultiWikiVersionCreatedEvent;
import de.justsoftware.onx.multiwiki.shared.i18n.MultiWikiMessages;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionChangedEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionUnchangedEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersionSection;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.MultiLangBook;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.util.server.HtmlDiffUtil;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.transform.TransformerConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.xml.sax.SAXException;

@Service
public class MultiWikiServiceImpl
implements MultiWikiService {
    private static final Logger LOG = LoggerFactory.getLogger(MultiWikiServiceImpl.class);
    private static final ImmutableSet<Action> WIKI_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.MULTI_WIKI_SAVE, (Object)StaticAction.MULTI_WIKI_VIEW_AS_ROLE);
    @Autowired
    private Settings _settings;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private MultiWikiReadDataService _multiWikiReadDataService;
    @Autowired
    private MultiWikiWriteDataService _multiWikiWriteDataService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    @Autowired
    private AntiSamyService _antiSamyService;
    @Autowired
    private PersonSettingService _personSettingService;

    @Nonnull
    private MultiWiki getMultiWikiByIdNonnull(@Nonnull MultiWikiId id) throws InvalidIDException {
        return InvalidIDException.check(id, (MultiWiki)this._multiWikiReadDataService.getWikisByIds((Set<MultiWikiId>)ImmutableSet.of((Object)id)).get((Object)id));
    }

    @Nonnull
    private MultiWikiVersion getWikiVersionByIdNonnull(@Nonnull MultiWikiVersionId id) throws InvalidIDException {
        return InvalidIDException.check(id, (MultiWikiVersion)this._multiWikiReadDataService.getWikiVersionsByIds((Set<MultiWikiVersionId>)ImmutableSet.of((Object)id)).get((Object)id));
    }

    @Override
    public MultiWikiVersion getWikiVersionById(MultiWikiVersionId id, AuthorizationCheckContext authCtx) throws InvalidIDException {
        MultiWikiVersion version = this.getWikiVersionByIdNonnull(id);
        authCtx.check(version, (Action)StaticAction.MULTI_WIKI_READ);
        return version;
    }

    @Nonnull
    private MultiWikiVersionSection getWikiSectionByIdNonnull(@Nonnull MultiWikiVersionSectionId id) throws InvalidIDException {
        return InvalidIDException.check(id, (MultiWikiVersionSection)this._multiWikiReadDataService.getWikiSectionsByIds((Set<MultiWikiVersionSectionId>)ImmutableSet.of((Object)id)).get((Object)id));
    }

    @Override
    public MultiWikiVersionSection getWikiSectionById(MultiWikiVersionSectionId id, AuthorizationCheckContext authCtx) throws InvalidIDException {
        MultiWikiVersionSection sectionFromDb = (MultiWikiVersionSection)this._multiWikiReadDataService.getWikiSectionsByIds((Set<MultiWikiVersionSectionId>)ImmutableSet.of((Object)id)).get((Object)id);
        MultiWikiVersionSection section = (MultiWikiVersionSection)this.versionSectionModelFunction(id).apply((Object)sectionFromDb);
        authCtx.check(section, (Action)StaticAction.MULTI_WIKI_READ);
        return section;
    }

    @Nonnull
    private Function<MultiWikiVersionSection, MultiWikiVersionSection> versionSectionModelFunction(@Nonnull MultiWikiVersionSectionId id) throws InvalidIDException {
        MultiWikiVersionSection versionSection = this.getWikiSectionByIdNonnull(id);
        MultiWikiVersion wikiVersion = this.getWikiVersionByIdNonnull(versionSection.getParentId());
        final MultiWiki parentWiki = this.getMultiWiki(wikiVersion);
        final EntityType parentEntityType = this.getEntityType(parentWiki.getId());
        return new Function<MultiWikiVersionSection, MultiWikiVersionSection>(){

            public MultiWikiVersionSection apply(MultiWikiVersionSection section) {
                if (section == null) {
                    return null;
                }
                ImmutableSet<String> verifiedRoleNameList = MultiWikiServiceImpl.this.getVerifiedRoleNames((Set<String>)section.getSelectedRolesAllowedToRead(), parentWiki.getId(), parentEntityType);
                return new MultiWikiVersionSection(section, verifiedRoleNameList);
            }
        };
    }

    @Nonnull
    private Function<MultiWikiVersionSection, MultiWikiSectionClientModel> sectionClientModelFunction(final @Nonnull MultiWiki parentWiki, final @Nonnull EntityType parentEntityType, final @Nonnull MultiWikiVersionId parentWikiVersionId) throws InvalidIDException {
        return new Function<MultiWikiVersionSection, MultiWikiSectionClientModel>(){

            public MultiWikiSectionClientModel apply(MultiWikiVersionSection section) {
                if (section == null) {
                    return null;
                }
                ImmutableList verifiedRoleNameList = MultiWikiServiceImpl.this.getVerifiedRoleNames((Set<String>)section.getSelectedRolesAllowedToRead(), parentWiki.getId(), parentEntityType).asList();
                return new MultiWikiSectionClientModel(section.getSectionId(), section.getHeadline(), section.getText(), (ImmutableList<String>)verifiedRoleNameList, parentWikiVersionId);
            }
        };
    }

    @Override
    public MultiWikiClientModel getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        MultiWikiId wikiId = this.getWikiIdByParentId(entity.getId());
        PersonId personId = authorizationContext.getUserId();
        String roleToViewMultiWiki = this.getDefaultViewRole(personId);
        return this.getCurrentWiki(wikiId, roleToViewMultiWiki, authorizationContext);
    }

    @CheckForNull
    private String getDefaultViewRole(@Nullable PersonId personId) {
        return this._personSettingService.getSettings(personId).getRoleToViewMultiWiki();
    }

    @Override
    public MultiWikiClientModel getCurrentWiki(MultiWikiId wikiId, String viewAsMemberOfRole, AuthorizationCheckContextWithUserId currentUserAuthCtx) throws InvalidIDException {
        AuthorizationCheckContext authCtx;
        StaticAction action;
        String roleToApply;
        MultiWiki wiki = this.getMultiWikiByIdNonnull(wikiId);
        ImmutableSet<Action> may = currentUserAuthCtx.may(wiki, StaticAction.MULTI_WIKI_VIEW_AS_ROLE, StaticAction.MULTI_WIKI_SAVE, StaticAction.MULTI_WIKI_READ);
        boolean mayViewAsRole = may.contains((Object)StaticAction.MULTI_WIKI_VIEW_AS_ROLE);
        EntityId parentEntityId = wiki.getParentId();
        DBEntity parentEntity = this._entityService.getByIdNotNull(parentEntityId);
        ImmutableList rolesForViewAs = ImmutableList.of();
        ImmutableList rolesAvailableByConfig = ImmutableList.copyOf(this.getVisibilityRoleNames(parentEntity.getType(), wikiId));
        String string = roleToApply = mayViewAsRole && this.isValidRoleByConfig(viewAsMemberOfRole, (ImmutableList<AuthorityModel>)rolesAvailableByConfig) ? viewAsMemberOfRole : null;
        if (mayViewAsRole) {
            if (may.contains((Object)StaticAction.MULTI_WIKI_SAVE)) {
                rolesForViewAs = ImmutableList.copyOf((Collection)rolesAvailableByConfig);
            } else if (may.contains((Object)StaticAction.MULTI_WIKI_READ)) {
                ImmutableSet<Role> rolesFromAuhorities = this.getRolesFromAuthorities((ImmutableList<AuthorityModel>)rolesAvailableByConfig);
                ImmutableSet<String> personAuthorities = AuthorityUtil.names(currentUserAuthCtx.hasAuthorities(wiki, rolesFromAuhorities));
                if (!personAuthorities.contains((Object)roleToApply)) {
                    roleToApply = null;
                }
                if (personAuthorities.size() >= 2) {
                    ImmutableMap configAuthorityMap = Maps.uniqueIndex((Iterable)rolesAvailableByConfig, AuthorityModel.TO_NAME);
                    rolesForViewAs = FluentIterable.from(personAuthorities).transform(Functions.forMap((Map)configAuthorityMap, null)).filter(Predicates.notNull()).toList();
                }
            }
        }
        if (roleToApply != null) {
            action = StaticAction.MULTI_WIKI_READ_WITHOUT_ENTITY_CHECK;
            authCtx = currentUserAuthCtx.getContextForRoles(this.getImplicitUserRolesFor(roleToApply));
        } else {
            action = StaticAction.MULTI_WIKI_READ;
            authCtx = currentUserAuthCtx;
        }
        ImmutableMap<EntityId, MultiWikiVersionId> currentMultiWikiVersions = this.getCurrentMultiWikiVersions((Map<EntityId, DBEntity>)ImmutableMap.of((Object)parentEntityId, (Object)parentEntity), (Map<EntityId, MultiWikiId>)ImmutableMap.of((Object)parentEntityId, (Object)wikiId), currentUserAuthCtx);
        MultiWikiVersionId versionId = InvalidIDException.check(parentEntityId, (MultiWikiVersionId)currentMultiWikiVersions.get((Object)parentEntityId));
        return this.getCurrentWikiInternal(wiki, versionId, action, authCtx, (ImmutableList<AuthorityModel>)rolesAvailableByConfig, (ImmutableList<AuthorityModel>)rolesForViewAs, roleToApply);
    }

    @Nonnull
    private ImmutableSet<Role> getImplicitUserRolesFor(@Nonnull String roleName) {
        Role ownRole = AuthorityUtil.valueOf(this._personRoleService.getAllPersonAndStaticRoles(), roleName);
        if (StaticPredefinedRole.ALL.equals(ownRole)) {
            return ImmutableSet.of((Object)StaticPredefinedRole.ALL);
        }
        return ImmutableSet.of((Object)ownRole, (Object)StaticPredefinedRole.ALL, (Object)StaticPredefinedRole.LOGGED_IN);
    }

    private boolean isValidRoleByConfig(@Nullable String viewAsMemberOfRole, @Nonnull ImmutableList<AuthorityModel> rolesAvailableByConfig) {
        if (viewAsMemberOfRole == null) {
            return true;
        }
        ImmutableSet configRoleNames = ImmutableSet.copyOf((Collection)Lists.transform(rolesAvailableByConfig, AuthorityModel.TO_NAME));
        return configRoleNames.contains((Object)viewAsMemberOfRole);
    }

    @Nonnull
    private ImmutableSet<Role> getRolesFromAuthorities(@Nonnull ImmutableList<AuthorityModel> authorities) {
        final ImmutableMap<String, ? extends Role> allPersonAndStaticRoles = this._personRoleService.getAllPersonAndStaticRoles();
        return FluentIterable.from(authorities).transform((Function)new Function<AuthorityModel, Role>(){

            public Role apply(AuthorityModel input) {
                if (input == null) {
                    return null;
                }
                return (Role)allPersonAndStaticRoles.get((Object)input.getAuthority());
            }
        }).filter(Predicates.notNull()).toSet();
    }

    @Nonnull
    private MultiWikiClientModel getCurrentWikiInternal(@Nonnull MultiWiki wiki, @Nonnull MultiWikiVersionId versionId, @Nonnull Action filterAllowedSectionsWith, @Nonnull AuthorizationCheckContext authCtx, @Nonnull ImmutableList<AuthorityModel> rolesForSectionRead, @Nonnull ImmutableList<AuthorityModel> rolesForViewAs, @Nullable String viewedAsRole) throws InvalidIDException {
        ImmutableList<MultiWikiVersionSection> sections = this._multiWikiReadDataService.getSectionsInVersion(versionId);
        AlbumId albumId = this._albumService.getNoModuleDBAlbumByParentId(wiki.getId()).getId();
        EntityType entityType = this.getEntityType(wiki);
        Iterable<MultiWikiVersionSection> visibleSections = authCtx.filterAllowedItems(sections, filterAllowedSectionsWith);
        MultiWikiVersion multiWikiVersion = this.getWikiVersionByIdNonnull(versionId);
        ImmutableList clientSections = ImmutableList.copyOf((Iterable)Iterables.transform(visibleSections, this.sectionClientModelFunction(wiki, entityType, multiWikiVersion.getId())));
        return new MultiWikiClientModel(wiki.getId(), versionId, albumId, (ImmutableList<MultiWikiSectionClientModel>)clientSections, viewedAsRole == null ? authCtx.may((ItemId)wiki.getId(), WIKI_CHECK_ACTIONS) : ImmutableSet.of(), this._entityConfigService.multiWikiMaxSections(entityType), this._entityConfigService.multiWikiToc(entityType), (ImmutableList<AuthorityModel>)FluentIterable.from(rolesForSectionRead).filter(AuthorityModel.IS_VISIBLE).toList(), rolesForViewAs, viewedAsRole);
    }

    @Override
    public ImmutableListMultimap<EntityId, MultiWikiVersionSection> getCurrentPublishedSections(Set<EntityId> entityIds) {
        ImmutableMap<EntityId, MultiWikiVersionId> versions = this.getPublishedMultiWikiVersionId(entityIds);
        ImmutableListMultimap<MultiWikiVersionId, MultiWikiVersionSection> sections = this._multiWikiReadDataService.getSectionsInVersions((Set<MultiWikiVersionId>)ImmutableSet.copyOf((Collection)versions.values()));
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry entry : versions.entrySet()) {
            result.putAll((Object)((EntityId)entry.getKey()), (Iterable)sections.get((Object)((MultiWikiVersionId)entry.getValue())));
        }
        return result.build();
    }

    @Override
    public String getCompareData(SearchAuthorizationCheckContext authCtx, MultiWikiVersionId firstVersionId, MultiWikiVersionId secondVersionId) {
        if (firstVersionId == null && secondVersionId == null) {
            return null;
        }
        ImmutableMap<MultiWikiVersionId, MultiWikiVersion> versions = this._multiWikiReadDataService.getWikiVersionsByIds((Set<MultiWikiVersionId>)FluentIterable.from(Arrays.asList(firstVersionId, secondVersionId)).filter(Predicates.notNull()).toSet());
        ImmutableSet wikiIds = FluentIterable.from((Iterable)versions.values()).transform(MultiWikiVersion.GET_PARENT_ID).toSet();
        MultiWikiId wikiId = (MultiWikiId)Iterables.getOnlyElement((Iterable)wikiIds);
        for (MultiWikiVersion version : versions.values()) {
            authCtx.check(version, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.MULTI_WIKI_READ));
        }
        MultiWiki wiki = (MultiWiki)this._multiWikiReadDataService.getWikisByIds((Set<MultiWikiId>)ImmutableSet.of((Object)wikiId)).get((Object)wikiId);
        DBEntity entity = this._entityService.getById(wiki.getParentId());
        EntityType entityType = InvalidIdServiceException.check(entity).getType();
        String firstVersionString = firstVersionId != null ? this.getMultiWikiVersionAsHtmlInternal(firstVersionId, wikiId, entityType, authCtx) : "";
        String secondVersionString = secondVersionId != null ? this.getMultiWikiVersionAsHtmlInternal(secondVersionId, wikiId, entityType, authCtx) : "";
        try {
            return HtmlDiffUtil.htmlDiff(firstVersionString, secondVersionString);
        }
        catch (TransformerConfigurationException e) {
            throw new ServiceException(e);
        }
        catch (SAXException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String getMultiWikiVersionAsHtml(SearchAuthorizationCheckContext authCtx, MultiWikiVersionId versionId) {
        MultiWikiVersion version = (MultiWikiVersion)this._multiWikiReadDataService.getWikiVersionsByIds((Set<MultiWikiVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        authCtx.check(version, (Action)StaticAction.MULTI_WIKI_READ);
        MultiWikiId wikiId = version.getParentId();
        MultiWiki wiki = (MultiWiki)this._multiWikiReadDataService.getWikisByIds((Set<MultiWikiId>)ImmutableSet.of((Object)wikiId)).get((Object)wikiId);
        DBEntity entity = this._entityService.getById(wiki.getParentId());
        return this.getMultiWikiVersionAsHtmlInternal(versionId, wiki.getId(), InvalidIdServiceException.check(entity).getType(), authCtx);
    }

    @Nonnull
    private String getMultiWikiVersionAsHtmlInternal(@Nonnull MultiWikiVersionId versionId, @Nonnull MultiWikiId multiWikiId, @Nonnull EntityType entityType, @Nonnull SearchAuthorizationCheckContext authCtx) {
        StringBuilder builder = new StringBuilder();
        ImmutableList<MultiWikiVersionSection> secondSections = this._multiWikiReadDataService.getSectionsInVersion(versionId);
        Iterable<MultiWikiVersionSection> visibleSections = authCtx.filterAllowedItems(secondSections, StaticAction.MULTI_WIKI_READ);
        for (MultiWikiVersionSection section : visibleSections) {
            builder.append("<div class=\"infobox clearfix\">");
            builder.append("<div class=\"ib_header\">");
            builder.append("<span class=\"multi-wiki-compare-section-header\">");
            this.appendHeadlineHtml(builder, section);
            builder.append("</span>");
            this.appendVisibilityRoles(builder, section, multiWikiId, entityType, authCtx.getLocale());
            builder.append("</div>");
            builder.append("<div class=\"infoContent\">");
            builder.append(section.getText());
            builder.append("</div></div>");
        }
        String secondVersionString = builder.toString();
        return secondVersionString;
    }

    private void appendHeadlineHtml(@Nonnull StringBuilder builder, @Nonnull MultiWikiVersionSection section) {
        builder.append(section.getHeadline());
    }

    private void appendVisibilityRoles(@Nonnull StringBuilder builder, @Nonnull MultiWikiVersionSection section, @Nonnull MultiWikiId multiWikiId, @Nonnull EntityType entityType, @Nonnull String locale) {
        ImmutableSet<String> roles = this.getVerifiedRoleNames((Set<String>)section.getSelectedRolesAllowedToRead(), multiWikiId, entityType);
        if (!roles.isEmpty()) {
            MultiLangBook translations = this._personService.getRolesTranslation();
            MultiWikiMessages wikiMessages = this._i18nService.createProxy(MultiWikiMessages.class, locale);
            builder.append("<span>(").append(wikiMessages.visibility()).append(": </span>");
            int i = 0;
            int max = roles.size();
            for (String role : roles) {
                builder.append("<span>").append(translations.getI18n(role).getFor(Language.of(locale))).append("</span>");
                if (i < max - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append(")");
        }
    }

    @Nonnull
    private ImmutableMap<EntityId, MultiWikiVersionId> getCurrentMultiWikiVersions(@Nonnull Map<EntityId, DBEntity> entities, @Nonnull Map<EntityId, MultiWikiId> multiWikis, @Nonnull AuthorizationCheckContext authCtx) {
        Set<EntityId> entitiyIds = entities.keySet();
        ImmutableMap<EntityId, EntityVersion> entityVersions = this._entityVersionService.getCurrentEntityVersions(entitiyIds, authCtx);
        ImmutableSet entityVersionsIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)entityVersions.values(), IEntityVersion.GET_ID));
        ImmutableMap<EntityVersionId, MultiWikiVersionId> multiWikiVersionsForEntityVersions = this._entityVersionService.getMultiWikiVersionsForEntityVersions((Set<EntityVersionId>)entityVersionsIds);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DBEntity entity : entities.values()) {
            EntityId entityId = entity.getId();
            EntityVersion version = (EntityVersion)entityVersions.get((Object)entityId);
            if (version == null) continue;
            MultiWikiVersionId multiWikiVersionId = (MultiWikiVersionId)multiWikiVersionsForEntityVersions.get((Object)version.getId());
            if (multiWikiVersionId != null) {
                result.put((Object)entityId, (Object)multiWikiVersionId);
                continue;
            }
            MultiWikiId wikiId = multiWikis.get(entityId);
            if (wikiId == null) continue;
            result.put((Object)entityId, (Object)this.createInitialMultiWikiVersion(entity, wikiId, version.getId()));
        }
        return result.build();
    }

    @Override
    public ImmutableMap<EntityId, String> getTeaserTexts(Map<EntityId, DBEntity> entities, AuthorizationCheckContext authCtx) {
        if (entities.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap<EntityId, MultiWikiId> multiWikis = this._multiWikiReadDataService.getWikisByParentIds(entities.keySet());
        ImmutableMap<EntityId, MultiWikiVersionId> versions = this.getCurrentMultiWikiVersions(entities, (Map<EntityId, MultiWikiId>)multiWikis, authCtx);
        ImmutableListMultimap<MultiWikiVersionId, MultiWikiVersionSection> sectionsByVersion = this._multiWikiReadDataService.getSectionsInVersions((Set<MultiWikiVersionId>)ImmutableSet.copyOf((Collection)versions.values()));
        final ImmutableSetMultimap may = authCtx.may(sectionsByVersion.values(), ImmutableSet.of((Object)StaticAction.MULTI_WIKI_READ));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : versions.entrySet()) {
            ImmutableList sections = sectionsByVersion.get((Object)((MultiWikiVersionId)entry.getValue()));
            Optional firstVisible = Iterables.tryFind((Iterable)sections, (Predicate)new Predicate<MultiWikiVersionSection>(){

                public boolean apply(@Nullable MultiWikiVersionSection input) {
                    return input != null && may.get((Object)Optional.of((Object)input.getId())).contains((Object)StaticAction.MULTI_WIKI_READ);
                }
            });
            if (!firstVisible.isPresent()) continue;
            result.put((Object)((EntityId)entry.getKey()), (Object)((MultiWikiVersionSection)firstVisible.get()).getText());
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<EntityId, MultiWikiVersionId> getPublishedMultiWikiVersionId(@Nonnull Set<EntityId> entityIds) {
        Map<EntityId, DBEntity> entities = this._entityService.getByIds(entityIds);
        Predicate<DBEntity> releaseProcessMandatory = new Predicate<DBEntity>(){

            public boolean apply(DBEntity entity) {
                return entity != null && MultiWikiServiceImpl.this._entityConfigService.releaseProcessMandatory(entity.getType());
            }
        };
        Map versioned = Maps.filterValues(entities, (Predicate)releaseProcessMandatory);
        ImmutableMap<EntityId, EntityVersion> activePublicVersions = this._entityVersionService.getNewestVersionsWithStatus(versioned.keySet(), (Set<EntityStatus>)this._entityConfigService.getPublishedEntityStatus());
        ImmutableMap<EntityVersionId, MultiWikiVersionId> multiWikiVersionsForEntityVersions = this._entityVersionService.getMultiWikiVersionsForEntityVersions((Set<EntityVersionId>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)activePublicVersions.values(), IEntityVersion.GET_ID)));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry activePublicVersion : activePublicVersions.entrySet()) {
            MultiWikiVersionId mwv = (MultiWikiVersionId)multiWikiVersionsForEntityVersions.get((Object)((EntityVersion)activePublicVersion.getValue()).getId());
            if (mwv == null) continue;
            result.put((Object)((EntityId)activePublicVersion.getKey()), (Object)mwv);
        }
        ImmutableMap<EntityId, MultiWikiId> wikiByParents = this._multiWikiReadDataService.getWikisByParentIds((Set<EntityId>)Sets.difference(entities.keySet(), versioned.keySet()));
        ImmutableMap<MultiWikiId, MultiWikiVersionId> newestVersions = this._multiWikiReadDataService.getNewestVersions((Set<MultiWikiId>)ImmutableSet.copyOf((Collection)wikiByParents.values()));
        for (Map.Entry wikiByParent : wikiByParents.entrySet()) {
            MultiWikiVersionId mwv = (MultiWikiVersionId)newestVersions.get(wikiByParent.getValue());
            if (mwv == null) continue;
            result.put((Object)((EntityId)wikiByParent.getKey()), (Object)mwv);
        }
        return result.build();
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
        for (final DBEntity parentEntity : entities) {
            this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    MultiWikiId wikiId = MultiWikiServiceImpl.this._multiWikiWriteDataService.insertWiki(parentEntity.getId());
                    MultiWikiServiceImpl.this.createInitialMultiWikiVersion(parentEntity, wikiId, null);
                }
            });
        }
    }

    @Nonnull
    private MultiWikiVersionId createInitialMultiWikiVersion(final @Nonnull DBEntity parentEntity, final @Nonnull MultiWikiId wikiId, final @Nullable EntityVersionId entityVersionId) {
        final I18nDefaultContents defaultTexts = this.getI18nDefaultContents(parentEntity);
        final ImmutableList.Builder events = ImmutableList.builder();
        MultiWikiVersionId result = this._transactionHelper.doInTransaction(new TransactionCallback<MultiWikiVersionId>(){

            public MultiWikiVersionId doInTransaction(TransactionStatus status) {
                MultiWikiVersionId versionId = MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersion(wikiId);
                if (entityVersionId != null) {
                    MultiWikiServiceImpl.this._entityVersionService.createEntityVersionComponents(versionId, entityVersionId, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
                } else {
                    MultiWikiServiceImpl.this._entityVersionService.createEntityVersionComponents(versionId, parentEntity.getId(), arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
                }
                EntityType entityType = parentEntity.getType();
                MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersionSection(versionId, null, defaultTexts._defaultHeadline, defaultTexts._defaultSectionText, 0, (Iterable<String>)MultiWikiServiceImpl.this.getDefaultVisibilityRoleNames(entityType, wikiId));
                return versionId;
            }
        });
        events.add((Object)new MultiWikiVersionCreatedEvent(parentEntity.getId()));
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return result;
    }

    @Nonnull
    private I18nDefaultContents getI18nDefaultContents(@Nonnull DBEntity parentEntity) {
        EntityMember admin = this._entityAdministrationService.getAdmin(parentEntity.getId());
        DBPerson person = null;
        if (admin != null) {
            PersonId adminId = admin.getPersonId();
            person = this._personService.getPersonById(adminId);
        }
        EntityConstants entityConstants = null;
        if (person != null) {
            entityConstants = this._i18nService.getEntityConstantsByEntityType(parentEntity.getType(), person.getLanguageId());
        } else {
            LOG.error("Could not find admin for entity with id: " + parentEntity.getId() + ". Applying default language.");
            entityConstants = this._i18nService.getEntityConstantsByEntityType(parentEntity.getType(), this._settings.defaultLanguage());
        }
        I18nDefaultContents result = new I18nDefaultContents(entityConstants.defaultMultiWikiSectionHeadline(), entityConstants.defaultMultiWikiSectionText());
        return result;
    }

    @CheckForNull
    private MultiWikiVersionSection getSectionInSections(@Nonnull List<MultiWikiVersionSection> oldSections, @Nullable MultiWikiSectionId sectionId) throws InvalidIDException {
        if (sectionId != null) {
            for (MultiWikiVersionSection section : oldSections) {
                if (!section.getSectionId().equals(sectionId)) continue;
                return section;
            }
            throw new InvalidIDException(sectionId);
        }
        return null;
    }

    @Override
    public MultiWikiVersionId saveMultiWiki(final MultiWikiId wikiId, final MultiWikiVersionId currentVersion, final Iterable<? extends MultiWikiSectionEditModel> sections, final AuthorizationCheckContextWithUserId authCtx) throws InvalidIDException {
        authCtx.check((ItemId)wikiId, (Action)StaticAction.MULTI_WIKI_SAVE);
        final MultiWiki wiki = this.getMultiWikiByIdNonnull(wikiId);
        final ImmutableList.Builder events = ImmutableList.builder();
        MultiWikiVersionId result = this._transactionHelper.doInTransaction(new TransactionCallback<MultiWikiVersionId>(){

            public MultiWikiVersionId doInTransaction(TransactionStatus status) {
                MultiWikiServiceImpl.this.checkVersionToEditIsCurrentVersion(wikiId, currentVersion);
                ImmutableMap currentSectionsById = Maps.uniqueIndex(MultiWikiServiceImpl.this._multiWikiReadDataService.getSectionsInVersion(currentVersion), IMultiWikiVersionSection.GET_SECTION_ID);
                int multiWikiMaxSections = MultiWikiServiceImpl.this._entityConfigService.multiWikiMaxSections(MultiWikiServiceImpl.this.getEntityType(wiki));
                int existingSectionsCount = Identifiables.toIdSet(sections).size();
                int allowedNewSections = Math.max(multiWikiMaxSections - existingSectionsCount, 0);
                if (Iterables.size((Iterable)sections) - existingSectionsCount > allowedNewSections) {
                    throw new ServiceException("Only " + multiWikiMaxSections + " sections are allowed. You must not add new sections.");
                }
                MultiWikiVersionId newVersionId = MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersion(wikiId);
                SaveMultiWikiSectionEditModelVisitor saveSectionsVisitor = new SaveMultiWikiSectionEditModelVisitor(newVersionId, (ImmutableMap<MultiWikiSectionId, MultiWikiVersionSection>)currentSectionsById);
                for (MultiWikiSectionEditModel sectionEditModel : sections) {
                    sectionEditModel.accept(saveSectionsVisitor);
                }
                MultiWikiServiceImpl.this._entityVersionService.createNewDraftVersionForMultiWikiVersion(wiki.getParentId(), currentVersion, newVersionId, authCtx, arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
                return newVersionId;
            }
        });
        events.add((Object)new MultiWikiVersionCreatedEvent(wiki.getParentId()));
        this._eventBus.post((Iterable<? extends ServerEvent>)events.build());
        return result;
    }

    @Override
    public MultiWikiVersionId restoreVersion(MultiWikiId wikiId, MultiWikiVersionId currentVersion, MultiWikiVersionId versionIdToRestore, AuthorizationCheckContext authCtx) throws InvalidIDException {
        authCtx.check((ItemId)versionIdToRestore, (Action)StaticAction.MULTI_WIKI_SAVE);
        this.checkVersionToEditIsCurrentVersion(wikiId, currentVersion);
        final MultiWikiVersion version = this.getWikiVersionById(versionIdToRestore, authCtx);
        final ImmutableList<MultiWikiVersionSection> oldSections = this._multiWikiReadDataService.getSectionsInVersion(versionIdToRestore);
        return this._transactionHelper.doInTransaction(new TransactionCallback<MultiWikiVersionId>(){

            public MultiWikiVersionId doInTransaction(TransactionStatus status) {
                MultiWikiVersionId newVersionId = MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersion(version.getParentId());
                int i = 0;
                for (MultiWikiVersionSection s : oldSections) {
                    MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersionSection(newVersionId, s.getSectionId(), s.getHeadline(), s.getText(), i, (Iterable<String>)s.getSelectedRolesAllowedToRead());
                    ++i;
                }
                return newVersionId;
            }
        });
    }

    @Nonnull
    private ImmutableSet<String> getVerifiedRoleNames(@Nonnull Set<String> roleNamesToVerify, @Nonnull MultiWikiId multiWikiId, @Nonnull EntityType entityType) {
        ImmutableMap<String, ConfOption> options = this.getMultiWikiPrivacyOptionsForEntityType(entityType, multiWikiId, StaticRight.MULTI_WIKI_VERSION_SECTION_READ).getOptions();
        return FluentIterable.from((Iterable)options.values()).filter(ConfOption.IS_FORCED).filter(ConfOption.IS_VISIBLE).transform(ConfOption.GET_OPTION_NAME).append((Iterable)Sets.intersection(roleNamesToVerify, (Set)options.keySet())).toSet();
    }

    @Override
    public ImmutableList<AuthorityModel> getVisibilityRoleNames(EntityType entityType, MultiWikiId multiWikiId) {
        return FluentIterable.from((Iterable)this.getMultiWikiPrivacyOptionsForEntityType(entityType, multiWikiId, StaticRight.MULTI_WIKI_VERSION_SECTION_READ).getOptions().values()).transform(ConfOption.GET_AUTHORITY_MODEL).toList();
    }

    @Nonnull
    private ImmutableSet<String> getDefaultVisibilityRoleNames(@Nonnull EntityType entityType, @Nonnull MultiWikiId multiWikiId) {
        return FluentIterable.from((Iterable)this.getMultiWikiPrivacyOptionsForEntityType(entityType, multiWikiId, StaticRight.MULTI_WIKI_VERSION_SECTION_READ).getOptions().values()).filter(ConfOption.IS_DEFAULT).transform(ConfOption.GET_OPTION_NAME).toSet();
    }

    @Nonnull
    private ConfOptionsFor getMultiWikiPrivacyOptionsForEntityType(@Nonnull EntityType entityType, @Nonnull MultiWikiId multiWikiId, @Nonnull Right right) {
        try {
            MultiWiki multiWiki = this.getMultiWikiByIdNonnull(multiWikiId);
            return this._configFileService.getConfigFile().getConfOption(Path.builder().add(entityType).add(multiWiki).add(right).build());
        }
        catch (EvalException e) {
            LOG.error("Could not load default component configuration", (Throwable)e);
            throw new ServiceException(e);
        }
        catch (InvalidIDException e) {
            LOG.error("Wiki with id " + multiWikiId + " not found." + e.getMessage(), (Throwable)e);
            throw new ServiceException("Wiki with id " + multiWikiId + " not found.");
        }
    }

    @Override
    public ImmutableMap<MultiWikiVersionSectionId, Path> getPathsForWikiSectionRead(Map<MultiWikiVersionSectionId, MultiWikiVersionSection> sections) {
        ImmutableSet versionIds = FluentIterable.from(sections.values()).transform(IMultiWikiVersionSection.GET_PARENT_ID).filter(Predicates.notNull()).toSet();
        final ImmutableMap<MultiWikiVersionId, MultiWikiVersion> wikiVersions = this._multiWikiReadDataService.getWikiVersionsByIds((Set<MultiWikiVersionId>)versionIds);
        ImmutableSet wikiIds = FluentIterable.from((Iterable)wikiVersions.values()).transform(IMultiWikiVersion.GET_PARENT_ID).filter(Predicates.notNull()).toSet();
        final ImmutableMap<MultiWikiId, MultiWiki> multiWikis = this._multiWikiReadDataService.getWikisByIds((Set<MultiWikiId>)wikiIds);
        ImmutableSet entityIds = FluentIterable.from((Iterable)multiWikis.values()).transform(IMultiWiki.GET_PARENT_ID).filter(Predicates.notNull()).toSet();
        final Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)entityIds);
        Map result = Maps.transformValues(sections, (Function)new NullPermeableFunction<MultiWikiVersionSection, Path>(){

            @Override
            protected Path applySafe(MultiWikiVersionSection input) {
                MultiWikiVersion wikiVersion = (MultiWikiVersion)wikiVersions.get((Object)input.getParentId());
                if (wikiVersion == null) {
                    return null;
                }
                MultiWiki multiWiki = (MultiWiki)multiWikis.get((Object)wikiVersion.getParentId());
                if (multiWiki == null) {
                    return null;
                }
                DBEntity entity = (DBEntity)entities.get(multiWiki.getParentId());
                if (entity == null) {
                    return null;
                }
                return Path.builder().add(new EntityItem(entity)).add(multiWiki).add(StaticRight.MULTI_WIKI_VERSION_SECTION_READ).build();
            }
        });
        return ImmutableMap.copyOf((Map)Maps.filterValues((Map)result, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    private EntityType getEntityType(@Nonnull MultiWikiId wikiId) throws InvalidIDException {
        return this.getEntityType(this.getMultiWikiByIdNonnull(wikiId));
    }

    @Nonnull
    private EntityType getEntityType(@Nonnull MultiWiki wiki) {
        return this._entityService.getByIdNotNull(wiki.getParentId()).getType();
    }

    @Nonnull
    private MultiWiki getMultiWiki(@Nonnull MultiWikiVersion multiWikiVersion) throws InvalidIDException {
        return this.getMultiWikiByIdNonnull(multiWikiVersion.getParentId());
    }

    @Override
    public MultiWikiId getWikiIdByParentId(EntityId entityId) throws InvalidIDException {
        return InvalidIDException.check(entityId, (MultiWikiId)this._multiWikiReadDataService.getWikisByParentIds((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId));
    }

    @Override
    public ImmutableList<MultiWikiVersionSection> getSectionsInVersion(MultiWikiVersionId versionId) {
        return this._multiWikiReadDataService.getSectionsInVersion(versionId);
    }

    @Override
    public MultiWikiVersionId getCurrentWikiVersionId(MultiWikiId wikiId, AuthorizationCheckContext authCtx) throws InvalidIDException {
        authCtx.check((ItemId)wikiId, (Action)StaticAction.MULTI_WIKI_READ);
        return this._multiWikiReadDataService.getNewestVersion(wikiId);
    }

    private void checkVersionToEditIsCurrentVersion(@Nonnull MultiWikiId wikiId, @Nullable MultiWikiVersionId expectedVersion) {
        try {
            if (!this._multiWikiReadDataService.getNewestVersion(wikiId).equals(expectedVersion)) {
                throw new ConcurrentUpdateException();
            }
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException(e.getMessage());
        }
    }

    @Override
    public boolean isFirstMultiWikiSectionVisible(EntityId parentId, AuthorizationCheckContext authCtx) {
        DBEntity dbEntity = this._entityService.getByIdNotNull(parentId);
        Map<ComponentType, DBEntityComponent> components = this._entityService.getComponentsByEntity(dbEntity);
        DBEntityComponent multiWikiComponent = components.get(StaticComponentType.MULTI_WIKI);
        if (multiWikiComponent == null || !multiWikiComponent.isVisible()) {
            return false;
        }
        ImmutableList sections = this.getCurrentPublishedSections((Set<EntityId>)ImmutableSet.of((Object)parentId)).get((Object)parentId);
        if (sections.isEmpty()) {
            return false;
        }
        return authCtx.may((Item<?>)((Item)sections.get(0)), (Action)StaticAction.MULTI_WIKI_READ);
    }

    @Override
    public ImmutableListMultimap<EntityId, IMultiWikiVersionSection> getNewestSections(Set<EntityId> entityIds) {
        ImmutableMap<EntityId, MultiWikiId> wikiIds = this._multiWikiReadDataService.getWikisByParentIds(entityIds);
        ImmutableMap<MultiWikiId, MultiWikiVersionId> newest = this._multiWikiReadDataService.getNewestVersions((Set<MultiWikiId>)ImmutableSet.copyOf((Collection)wikiIds.values()));
        ImmutableListMultimap<MultiWikiVersionId, MultiWikiVersionSection> sections = this._multiWikiReadDataService.getSectionsInVersions((Set<MultiWikiVersionId>)ImmutableSet.copyOf((Collection)newest.values()));
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (EntityId entityId : entityIds) {
            result.putAll((Object)entityId, (Iterable)sections.get((Object)((MultiWikiVersionId)newest.get(wikiIds.get((Object)entityId)))));
        }
        return result.build();
    }

    @ParametersAreNonnullByDefault
    private final class SaveMultiWikiSectionEditModelVisitor
    implements MultiWikiSectionEditModel.MultiWikiSectionEditModelVisitor<MultiWikiVersionSectionId> {
        private final ImmutableMap<MultiWikiSectionId, MultiWikiVersionSection> _currentSectionsById;
        private final MultiWikiVersionId _newVersion;
        private int _position = 0;

        private SaveMultiWikiSectionEditModelVisitor(MultiWikiVersionId newVersion, ImmutableMap<MultiWikiSectionId, MultiWikiVersionSection> currentSectionsById) {
            this._currentSectionsById = currentSectionsById;
            this._newVersion = newVersion;
        }

        @Override
        public MultiWikiVersionSectionId visit(MultiWikiSectionChangedEditModel editModel) {
            return MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersionSection(this._newVersion, this.getValidSectionIdOrNull(editModel.getId()), editModel.getHeadline(), MultiWikiServiceImpl.this._antiSamyService.checkAndCleanHtml(editModel.getText()), this.nextPosition(), (Iterable<String>)editModel.getSelectedRolesAllowedToRead());
        }

        @Override
        public MultiWikiVersionSectionId visit(MultiWikiSectionUnchangedEditModel editModel) {
            MultiWikiVersionSection unchangedSection = (MultiWikiVersionSection)this._currentSectionsById.get((Object)editModel.getId());
            return MultiWikiServiceImpl.this._multiWikiWriteDataService.insertVersionSection(this._newVersion, this.getValidSectionIdOrNull(unchangedSection.getSectionId()), unchangedSection.getHeadline(), unchangedSection.getText(), this.nextPosition(), (Iterable<String>)unchangedSection.getSelectedRolesAllowedToRead());
        }

        @CheckForNull
        private MultiWikiSectionId getValidSectionIdOrNull(@Nullable MultiWikiSectionId sectionId) {
            return sectionId != null && this._currentSectionsById.containsKey((Object)sectionId) ? sectionId : null;
        }

        private int nextPosition() {
            return this._position++;
        }
    }

    private static class I18nDefaultContents {
        final String _defaultHeadline;
        final String _defaultSectionText;

        public I18nDefaultContents(@Nonnull String defaultHeadline, @Nonnull String defaultSectionText) {
            this._defaultHeadline = defaultHeadline;
            this._defaultSectionText = defaultSectionText;
        }
    }
}

