/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.EntityTeaserResolver;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersionSection;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface MultiWikiService
extends EntityModuleHandler,
EntityTeaserResolver {
    @Nonnull
    public MultiWikiVersion getWikiVersionById(MultiWikiVersionId var1, AuthorizationCheckContext var2) throws InvalidIDException;

    @Nonnull
    public MultiWikiVersionSection getWikiSectionById(MultiWikiVersionSectionId var1, AuthorizationCheckContext var2) throws InvalidIDException;

    @Nonnull
    public MultiWikiVersionId saveMultiWiki(MultiWikiId var1, MultiWikiVersionId var2, Iterable<? extends MultiWikiSectionEditModel> var3, AuthorizationCheckContextWithUserId var4) throws InvalidIDException;

    @Nonnull
    public MultiWikiClientModel getCurrentWiki(MultiWikiId var1, @Nullable String var2, AuthorizationCheckContextWithUserId var3) throws InvalidIDException;

    @CheckForNull
    public String getCompareData(SearchAuthorizationCheckContext var1, @Nullable MultiWikiVersionId var2, @Nullable MultiWikiVersionId var3);

    @Nonnull
    public String getMultiWikiVersionAsHtml(SearchAuthorizationCheckContext var1, MultiWikiVersionId var2);

    @Nonnull
    public MultiWikiVersionId restoreVersion(MultiWikiId var1, MultiWikiVersionId var2, MultiWikiVersionId var3, AuthorizationCheckContext var4) throws InvalidIDException;

    @Nonnull
    public ImmutableMap<MultiWikiVersionSectionId, Path> getPathsForWikiSectionRead(Map<MultiWikiVersionSectionId, MultiWikiVersionSection> var1);

    @Nonnull
    public MultiWikiId getWikiIdByParentId(EntityId var1) throws InvalidIDException;

    @Nonnull
    public ImmutableListMultimap<EntityId, MultiWikiVersionSection> getCurrentPublishedSections(Set<EntityId> var1);

    @Nonnull
    public ImmutableList<MultiWikiVersionSection> getSectionsInVersion(MultiWikiVersionId var1);

    @Nonnull
    public MultiWikiVersionId getCurrentWikiVersionId(MultiWikiId var1, AuthorizationCheckContext var2) throws InvalidIDException;

    @Nonnull
    public ImmutableList<AuthorityModel> getVisibilityRoleNames(EntityType var1, MultiWikiId var2);

    public boolean isFirstMultiWikiSectionVisible(EntityId var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableListMultimap<EntityId, IMultiWikiVersionSection> getNewestSections(Set<EntityId> var1);
}

