/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.controller;

import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.monitoring.business.model.QueueStatistics;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ParametersAreNonnullByDefault
public class QueueStatisticsController {
    @Autowired
    private QueueStatisticsService _statisticsService;

    @RequestMapping(value={"/monitoring/queues/{queueName}"}, method={RequestMethod.GET})
    @ResponseBody
    @Nonnull
    public String getQueueStatistics(@PathVariable String queueName) {
        QueueName qName = QueueName.byPathName(queueName);
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        QueueStatistics statistics = this._statisticsService.getStatistics(qName);
        StringBuffer result = new StringBuffer();
        result.append("THROUGHPUT=").append(statistics.getProcessed()).append('\n').append("AVG=").append(statistics.getAvgTime()).append('\n').append("MIN=").append(statistics.getMinTime()).append('\n').append("MAX=").append(statistics.getMaxTime()).append('\n').append("QSIZE=").append(statistics.getSize()).append('\n');
        this._statisticsService.reset(qName);
        return result.toString();
    }
}

