/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business.impl;

import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.message.search.business.ChatSearchService;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.monitoring.business.model.QueueStatistics;
import de.justsoftware.onx.searchnew.business.ConversationSearchIndexService;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.visibility.business.VisibilityService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueStatisticsServiceImpl
implements QueueStatisticsService {
    @Autowired
    private UpdateEventHandler _updateEventHandler;
    @Autowired
    private SearchIndexService _searchIndexService;
    @Autowired
    private ChatSearchService _chatSearchService;
    @Autowired
    private ConversationSearchIndexService _conversationSearchIndexService;
    @Autowired
    private VisibilityService _visibilityService;
    @Autowired
    private Clock _clock;
    private final HashMap<QueueName, Statistics> _statisticsMap = new HashMap();

    @Override
    public void itemsDequeued(QueueName queueName, Iterable<DateTime> queuedTimestamps) {
        Statistics statistics = this._statisticsMap.get((Object)queueName);
        if (statistics == null) {
            statistics = new Statistics();
            this._statisticsMap.put(queueName, statistics);
        }
        DateTime dequeueTime = this._clock.now();
        for (DateTime queuedTimestamp : queuedTimestamps) {
            long timeInQueue = dequeueTime.getMillis() - queuedTimestamp.getMillis();
            statistics.update(timeInQueue);
        }
    }

    @Override
    public void reset(QueueName queueName) {
        this._statisticsMap.remove((Object)queueName);
    }

    @Override
    public QueueStatistics getStatistics(QueueName queueName) {
        Statistics statistics = this._statisticsMap.get((Object)queueName);
        if (statistics == null) {
            statistics = new Statistics();
        }
        long size = this.getCurrentQueueSize(queueName);
        return statistics.toQueueStatistics(size);
    }

    private long getCurrentQueueSize(@Nonnull QueueName queueName) {
        switch (queueName) {
            case SEARCH_INDEX: {
                return this._searchIndexService.getQueueSize();
            }
            case UPDATE_EVENT: {
                return this._updateEventHandler.getQueueSize();
            }
            case CHAT_SEARCH: {
                return this._chatSearchService.getQueueSize();
            }
            case CONVERSATION_SEARCH: {
                return this._conversationSearchIndexService.getQueueSize();
            }
            case ITEM_VISIBILITY: {
                return this._visibilityService.getQueueSize();
            }
        }
        return 0L;
    }

    private static final class Statistics {
        private long _processed = 0L;
        private long _maxTime = 0L;
        private long _minTime = 0L;
        private long _avgTime = 0L;

        private Statistics() {
        }

        public void update(long timeInQueue) {
            this._maxTime = Math.max(this._maxTime, timeInQueue);
            this._avgTime = (long)((double)(this._avgTime * this._processed + timeInQueue) / (double)(this._processed + 1L));
            this._minTime = this._minTime == 0L ? timeInQueue : Math.min(this._minTime, timeInQueue);
            ++this._processed;
        }

        @Nonnull
        public QueueStatistics toQueueStatistics(long currentQueueSize) {
            return new QueueStatistics(this._processed, this._maxTime, this._minTime, this._avgTime, currentQueueSize);
        }
    }
}

