/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.integration.persistence.ibatis.PersonEntityMappingIbatisModel;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SubscriptionImportModel {
    private final ImmutableSetMultimap<EntityId, PersonId> _subscriptions;

    public SubscriptionImportModel(Set<EntityId> entityIds, Set<PersonId> personIds) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (EntityId entityId : entityIds) {
            builder.putAll((Object)entityId, personIds);
        }
        this._subscriptions = builder.build();
    }

    @CheckForNull
    public static SubscriptionImportModel fromPersonEntityRelation(PersonEntityMappingIbatisModel personEntityRelation, Map<String, PersonId> idMapping) {
        PersonId personId = idMapping.get(personEntityRelation.getExternalId());
        EntityId entityId = personEntityRelation.getEntityId();
        return personId == null ? null : new SubscriptionImportModel((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<PersonId>)ImmutableSet.of((Object)personId));
    }

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getSubscriptions() {
        return this._subscriptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subscriptions", this._subscriptions).toString();
    }
}

