/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class LDAPPersonIdentifier {
    private static final char SEPARATOR = '@';
    private final String _usernameField;
    private final String _username;
    private final String _domain;

    private LDAPPersonIdentifier(@Nonnull String usernameField, @Nonnull String username, @Nonnull String domain) {
        this._usernameField = usernameField;
        this._username = username;
        this._domain = domain;
    }

    @Nonnull
    public String getUsernameField() {
        return this._usernameField;
    }

    @Nonnull
    public String getUsername() {
        return this._username;
    }

    @Nonnull
    public String getDomain() {
        return this._domain;
    }

    @Nonnull
    public String toExternalIdString() {
        return this._domain.isEmpty() ? this._username : this._username + "@" + this._domain;
    }

    public String toString() {
        return this._usernameField + "=" + this.toExternalIdString();
    }

    @CheckForNull
    public static LDAPPersonIdentifier parse(@Nonnull String usernameField, @Nonnull String personIdentifier, @Nonnull DomainResolver domainResolver) {
        ImmutableList values = ImmutableList.copyOf((Iterable)Splitter.on((char)'@').omitEmptyStrings().split((CharSequence)personIdentifier));
        if (values.size() != 2) {
            return null;
        }
        return new LDAPPersonIdentifier(usernameField, (String)values.get(0), domainResolver.getDomain((String)values.get(1)).getName());
    }

    @Nonnull
    public static LDAPPersonIdentifier fromName(@Nonnull String usernameField, @Nonnull String username, @Nonnull DomainResolver.Domain domain) {
        return new LDAPPersonIdentifier(usernameField, username, domain.getName());
    }
}

