/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class GenericPersonImportModel
extends PersonImportModel<String> {
    private final ListMultimap<String, String> _personFields;
    private final ImmutableSet<String> _roles;
    private final Boolean _blockUser;

    public GenericPersonImportModel(String externalId, ListMultimap<String, String> personFields, ImmutableSet<String> roles, @Nullable Boolean blockUser) {
        super(new DBPerson(), externalId);
        this._personFields = personFields;
        this._roles = roles;
        this._blockUser = blockUser;
    }

    @Nonnull
    public ImmutableSet<String> getRoles() {
        return this._roles;
    }

    @CheckForNull
    public String getPersonField(String fieldName) {
        List attributeValues = this._personFields.get((Object)fieldName);
        String attributeValue = !attributeValues.isEmpty() ? (String)attributeValues.get(0) : null;
        return attributeValue;
    }

    @CheckForNull
    public Boolean getBlockUser() {
        return this._blockUser;
    }

    @Override
    public <R> R accept(PersonImportModelVisitor<R> v) {
        return v.visitGenericPersonImportModel(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("personFields", this._personFields == null ? null : Integer.valueOf(this._personFields.size())).add("roles", this._roles).add("blockUser", (Object)this._blockUser).addValue((Object)super.toString()).toString();
    }
}

