/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class IbatisStringIdEntityImportDAO
implements EntityImportDAO<String> {
    private static final String NAMESPACE = "EntityImport.";
    private SqlMapClient _sqlMapper;

    @Required
    public void setSqlMapper(@Nonnull SqlMapClient sqlMapper) {
        this._sqlMapper = sqlMapper;
    }

    @Override
    public void insertIdMapping(EntityId entityId, String externalId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("internalId", entityId);
        map.put("externalId", externalId.toLowerCase());
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "EntityImport.insertExternalAndInternalId", map);
    }

    @Override
    public EntityId getInternalId(String externalId) {
        return (EntityId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "EntityImport.getInternalIdByExternalId", externalId);
    }

    @Override
    public Map<String, EntityId> getInternalIds(Collection<String> externalIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "EntityImport.getInternalIdByExternalIds", "key", "value", ImmutableSet.copyOf(externalIds), IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
    }

    @Override
    public String getExternalId(EntityId internalId) {
        return (String)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "EntityImport.getExternalIdByInternalId", internalId);
    }
}

