/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class IbatisPersonImportMappingDAO
implements PersonImportMappingDAO {
    private static final String NAMESPACE = "PersonImportMapping.";
    private SqlMapClient _sqlMapper;

    @Required
    public void setSqlMapper(@Nonnull SqlMapClient sqlMapper) {
        this._sqlMapper = sqlMapper;
    }

    @Override
    public void insertIdMapping(PersonId personId, String username, Date lastImportedChanges) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "PersonImportMapping.insertUsernameAndPersonId", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"username", (Object)username.toLowerCase(), (Object)"lastImportedChanges", (Object)lastImportedChanges));
    }

    @Override
    public void removeIdMapping(PersonId personId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "PersonImportMapping.deleteUsernameByPersonId", personId);
    }

    @Override
    public void removeIdMapping(String externalId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "PersonImportMapping.deleteMappingByExternalId", externalId);
    }

    @Override
    public String getExternalId(PersonId personId) {
        return (String)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "PersonImportMapping.getUsernameByPersonId", personId);
    }

    @Override
    public PersonId getInternalId(String username) {
        return this.getInternalIds((Iterable<String>)ImmutableSet.of((Object)username)).get(username.toLowerCase());
    }

    @Override
    public Map<String, PersonId> getInternalIds(Iterable<String> externalPersonIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "PersonImportMapping.getPersonIdsByUsernames", "key", "value", ImmutableSet.copyOf(externalPersonIds), IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
    }

    @Override
    public Date getImportDate(PersonId internalId) {
        return (Date)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "PersonImportMapping.getImportDate", internalId);
    }

    @Override
    public ImmutableMap<PersonId, String> getExternalIds(Set<PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "PersonImportMapping.getExternalIdsByPersonIds", "key", "value", personIds, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
    }

    @Override
    public Map<String, PersonId> getAllMappings() {
        return IbatisDAOUtil.wrappedQueryForMap(this._sqlMapper, "PersonImportMapping.getAllMappings", null, "key", "value");
    }
}

