/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.migration.integration.persistence.MigrationMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.MigrationMappingNameAndKey;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisMigrationMappingDAOImpl
implements MigrationMappingDAO {
    private static final String NAME = "migration_name";
    private static final String KEY = "migration_key";
    private static final String VALUE = "migration_value";
    private static final String NAMESPACE = "MigrationMapping.";
    private static final Function<Object, MigrationMappingNameAndKey> MIGRATION_MAPPING_NAME_AND_KEY_FUNCTION = new Function<Object, MigrationMappingNameAndKey>(){

        public MigrationMappingNameAndKey apply(Object input) {
            String name = (String)IbatisDAOUtil.probe(input, IbatisMigrationMappingDAOImpl.NAME);
            if (name == null) {
                return null;
            }
            String key = (String)IbatisDAOUtil.probe(input, IbatisMigrationMappingDAOImpl.KEY);
            if (key == null) {
                return null;
            }
            return new MigrationMappingNameAndKey(name, key);
        }
    };
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;

    @Override
    public void insertMapping(String name, String key, String value) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "MigrationMapping.insert", ImmutableMap.of((Object)NAME, (Object)name, (Object)KEY, (Object)key, (Object)VALUE, (Object)value));
    }

    @Override
    public ImmutableSetMultimap<String, String> getByName(String name) {
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "MigrationMapping.getByName", KEY, VALUE, (Object)name);
    }

    @Override
    public ImmutableSetMultimap<String, String> getByNameAndKeys(final String name, Iterable<String> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return ImmutableSetMultimap.of();
        }
        Iterable nameAndKeys = Iterables.transform(keys, (Function)new Function<String, MigrationMappingNameAndKey>(){

            public MigrationMappingNameAndKey apply(String input) {
                return new MigrationMappingNameAndKey(name, (String)Preconditions.checkNotNull((Object)input));
            }
        });
        ImmutableSetMultimap<MigrationMappingNameAndKey, String> result = this.getByNamesAndKeys(nameAndKeys);
        ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : result.entries()) {
            MigrationMappingNameAndKey nameAndKey = (MigrationMappingNameAndKey)entry.getKey();
            resultBuilder.put((Object)nameAndKey.getKey(), (Object)((String)entry.getValue()));
        }
        return resultBuilder.build();
    }

    @Override
    public void deleteByName(String name) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "MigrationMapping.deleteByName", name);
    }

    @Override
    public void deleteByNameAndKeys(String name, Iterable<String> key) {
        if (CollectionUtil.isEmpty(key)) {
            return;
        }
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "MigrationMapping.deleteByNameAndKey", ImmutableMap.of((Object)NAME, (Object)name, (Object)KEY, IbatisDAOUtil.toIbatisList(key)));
    }

    @Override
    public ImmutableSet<String> getByNameAndKey(String name, String key) {
        MigrationMappingNameAndKey mapKey = new MigrationMappingNameAndKey(name, key);
        return this.getByNamesAndKeys(Lists.newArrayList((Object[])new MigrationMappingNameAndKey[]{mapKey})).get((Object)mapKey);
    }

    @Override
    public ImmutableSet<String> getByNameAndValue(String name, String value) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "MigrationMapping.getByNameAndValue", ImmutableMap.of((Object)NAME, (Object)name, (Object)VALUE, (Object)value));
    }

    @Override
    public ImmutableSetMultimap<MigrationMappingNameAndKey, String> getByNamesAndKeys(Iterable<MigrationMappingNameAndKey> namesAndKeys) {
        if (CollectionUtil.isEmpty(namesAndKeys)) {
            return ImmutableSetMultimap.of();
        }
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(this._sqlMapper, "MigrationMapping.getByNamesAndKeys", MIGRATION_MAPPING_NAME_AND_KEY_FUNCTION, VALUE, IbatisDAOUtil.toIbatisList(namesAndKeys));
    }
}

