/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class IbatisMigratedItemDAO
implements MigratedItemDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisMigratedItemDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("MigratedItem");
    }

    @Override
    public void insertMigrations(Map<? extends ItemId, ? extends ItemId> migrationMappings) {
        this._statementBuilder.batch(sqlMapClient -> migrationMappings.forEach((origin, destination) -> this._statementBuilder.insert("insert").param("originId", origin, "destinationId", destination)));
    }

    @Override
    public <T extends ItemId> ImmutableMap<T, ItemId> getMigrationsByIds(Set<T> itemIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getByOriginIds").partition(itemIds)).asMap("origin_id", "destination_id");
    }

    @Override
    public int migrateComments() {
        return (Integer)this._statementBuilder.update("migrateItemComments").noParam();
    }

    @Override
    public int migrateLikes() {
        return (Integer)this._statementBuilder.update("migrateItemLikes").noParam();
    }

    @Override
    public int migrateSubscriptions() {
        return (Integer)this._statementBuilder.update("migrateItemSubscriptions").noParam();
    }

    @Override
    public int migrateMicroblogAttachments() {
        return (Integer)this._statementBuilder.update("migrateItemMicroblogAttachments").noParam();
    }

    @Override
    public int migrateActivityMessagesOfType(WorkstreamMessageType sourceType, WorkstreamMessageType destinationType) {
        return (Integer)this._statementBuilder.update("migrateItemActivityMessagesOfType").param("srcType", sourceType, "destType", destinationType);
    }

    @Override
    public int deleteActivityMessagesOfTypes(WorkstreamMessageType ... messageTypes) {
        return (Integer)this._statementBuilder.delete("deleteItemActivityMessagesOfType").partition(ImmutableSet.copyOf((Object[])messageTypes));
    }

    @Override
    public void migrateDocumentNameForDriveDocumentComment() {
        this._statementBuilder.insertDbSpecific("migrateDocumentNewMessages").noParam();
    }
}

