/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.conversation.persistence;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilderFactory;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MigratedConversationIdDAO {
    private final IbatisStatementBuilder _statementBuilder;

    public MigratedConversationIdDAO(IbatisStatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("MigratedConversationId");
    }

    @VisibleForTesting
    void insert(Map<Long, ConversationId> ids) {
        this._statementBuilder.batch(sqlMapClient -> ids.forEach((originalId, migratedId) -> this._statementBuilder.insert("insertIds").param("originalId", originalId, "migratedId", migratedId)));
    }

    public void forAll(BiConsumer<String, ConversationId> rowHandler) {
        ((IbatisStandardResultBuilder)this._statementBuilder.select("getAll").noParam()).executeWithBiConsumer("original_id", "migrated_id", rowHandler);
    }
}

