/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.conversation;

import de.justsoftware.onx.message.shared.model.ConversationId;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MigratedConversationIdProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MigratedConversationIdProducer.class);
    private static final Callback LOG_ERROR_CALLBACK = (metadata, exception) -> {
        if (exception != null) {
            LOG.error("Could not publish entry from conversation id migration", (Throwable)exception);
        }
    };
    private final Producer<String, String> _producer;

    public MigratedConversationIdProducer(Producer<String, String> producer) {
        this._producer = producer;
    }

    public void send(String originalId, ConversationId migratedId) {
        this._producer.send(new ProducerRecord("just.drive.conversationidmigration", (Object)originalId, (Object)migratedId.asString()), LOG_ERROR_CALLBACK);
    }
}

