/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.mapper;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.business.mapper.commands.ActiveCommand;
import de.justsoftware.onx.migration.business.mapper.commands.BirthdayVisibilityCommand;
import de.justsoftware.onx.migration.business.mapper.commands.BlockedCommand;
import de.justsoftware.onx.migration.business.mapper.commands.DBPersonImportCommand;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommand;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommands;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PersonFieldsMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PersonFieldsMapper.class);
    private static final String DYNAMIC_FIELD_VALUE_SEPARATOR = ", ";
    private static final String USER_GROUP_MEMBERSHIPS_DELIMITER = ",";
    private final Map<String, SetCommand<PersonImportModel<?>>> _commandMap = new HashMap();
    private final JucoPasswordEncoder _passwordEncoder;

    public PersonFieldsMapper(JucoPasswordEncoder jucoPasswordEncoder) {
        this._passwordEncoder = jucoPasswordEncoder;
        this.initCommands();
    }

    private void initCommands() {
        this._commandMap.put("person.language", new DBPersonImportCommand(){

            @Override
            protected void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                String value = SetCommands.getSingleString(values);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    object.setLanguageId(value);
                }
            }
        });
        this._commandMap.put("person.email", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                object.setEmail(SetCommands.getSingleString(values));
            }
        });
        this._commandMap.put("person.firstname", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                object.setFirstName(SetCommands.getSingleString(values));
            }
        });
        this._commandMap.put("person.lastname", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                object.setLastName(SetCommands.getSingleString(values));
            }
        });
        this._commandMap.put("person.title", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                String value = SetCommands.getSingleString(values);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    object.setTitle(value);
                }
            }
        });
        this._commandMap.put("person.birthday", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                Object value = Iterables.getFirst(values, null);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    if (value instanceof Date) {
                        object.setBirthday(new DateWithoutTimezone((Date)value));
                    } else if (value instanceof String) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            object.setBirthday(new DateWithoutTimezone(df.parse((String)value)));
                        }
                        catch (ParseException e) {
                            LOG.error("Could not parse birthday " + value, (Throwable)e);
                        }
                    }
                }
            }
        });
        this._commandMap.put("person.birthdayGerman", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                Object value = Iterables.getFirst(values, null);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    if (value instanceof Date) {
                        object.setBirthday(new DateWithoutTimezone((Date)value));
                    } else if (value instanceof String) {
                        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                        try {
                            object.setBirthday(new DateWithoutTimezone(df.parse((String)value)));
                        }
                        catch (ParseException e) {
                            LOG.error("Could not parse birthday " + value, (Throwable)e);
                        }
                    }
                }
            }
        });
        this._commandMap.put("person.birthdayVisibility", new BirthdayVisibilityCommand());
        this._commandMap.put("person.active", new ActiveCommand());
        this._commandMap.put("person.blocked", new BlockedCommand());
        this._commandMap.put("person.terms", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                Object value = Iterables.getFirst(values, null);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    if (value instanceof Boolean) {
                        object.setTermsAccepted((Boolean)value);
                    } else if (value instanceof String) {
                        object.setTermsAccepted(BooleanUtils.toBooleanObject((String)((String)value)));
                    }
                }
            }
        });
        this._commandMap.put("person.password", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                Object value = Iterables.getFirst(values, null);
                String password = null;
                if (value instanceof byte[] || value instanceof Byte[]) {
                    password = new String((byte[])value, Charsets.UTF_8);
                } else if (value instanceof String) {
                    password = (String)value;
                }
                if (password != null) {
                    object.setPasswordHash(PersonFieldsMapper.this._passwordEncoder.encode(password));
                }
            }
        });
        this._commandMap.put("person.userGroupMemberships", (importModel, values, parameterAccess) -> {
            String value = SetCommands.getSingleString(values);
            if (value == null) {
                return;
            }
            List<UserGroupId> userGroupMemberships = Arrays.stream(value.split(USER_GROUP_MEMBERSHIPS_DELIMITER)).map(UserGroupId::fromString).collect(Collectors.toList());
            importModel.setAddedUserGroupMemberships(userGroupMemberships);
        });
        this._commandMap.put("person.removedUserGroupMemberships", (importModel, values, parameterAccess) -> {
            String value = SetCommands.getSingleString(values);
            if (value == null) {
                return;
            }
            List<UserGroupId> userGroupMemberships = Arrays.stream(value.split(USER_GROUP_MEMBERSHIPS_DELIMITER)).map(UserGroupId::fromString).collect(Collectors.toList());
            importModel.setRemovedUserGroupMemberships(userGroupMemberships);
        });
        this._commandMap.put("person.additionalTitle", new DBPersonImportCommand(){

            @Override
            public void setValue(DBPerson object, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                String value = SetCommands.getSingleString(values);
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    object.setAdditionalTitle(value);
                }
            }
        });
    }

    public void addDynamicAttributeCommands(ProfileAttributesConfiguration config) {
        ImmutableMap<String, String> attributesToSectionsMap = config.getAttributesToSectionsConfigMap();
        for (ProfileAttributeConfiguration conf : config.getAllAttributeConfigurations()) {
            String attributeName = conf.getName();
            this._commandMap.put("person.dynamic." + attributeName, (object, values, parameterAccess) -> {
                String value = StringUtils.trimToNull((String)Joiner.on((String)DYNAMIC_FIELD_VALUE_SEPARATOR).join(SetCommands.getMultipleString(values)));
                if (SetCommands.getSaveValuePredicate(parameterAccess.synchronize()).test(value)) {
                    String sectionName = (String)attributesToSectionsMap.get((Object)attributeName);
                    ProfileAttributeBlock block = object.getProfileAttributeBlocks().get(sectionName);
                    String multiValueSeparator = parameterAccess.getParameter("multiValueSeparator");
                    ProfileAttributeBlock updatedBlock = StringUtil.isBlank(multiValueSeparator) || StringUtil.isBlank(value) ? this.updateProfileAttributeBlock(conf, value, block) : this.updateProfileAttributeBlock(conf, this.getMultiValue(value, multiValueSeparator), block);
                    object.addProfileAttributeBlock(sectionName, updatedBlock);
                }
            });
        }
    }

    @Nonnull
    private ImmutableList<String> getMultiValue(String value, String separator) {
        return Arrays.stream(value.split(separator)).map(String::trim).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @Nonnull
    private ProfileAttributeBlock updateProfileAttributeBlock(ProfileAttributeConfiguration conf, @Nullable String value, @Nullable ProfileAttributeBlock block) {
        ImmutableList attributeValues = StringUtil.isBlank(value) ? ImmutableList.of() : ImmutableList.of((Object)value);
        return this.updateProfileAttributeBlock(conf, (ImmutableList<String>)attributeValues, block);
    }

    @Nonnull
    private ProfileAttributeBlock updateProfileAttributeBlock(ProfileAttributeConfiguration conf, ImmutableList<String> attributeValues, @Nullable ProfileAttributeBlock block) {
        String attributeName = conf.getName();
        if (block == null) {
            return ProfileAttributeBlock.builder(null).addAttributeValues(conf, attributeValues).build();
        }
        ImmutableList attributes = FluentIterable.from(block.getAttributes()).filter(input -> input != null && !Objects.equals(input.getName(), attributeName)).append((Object[])new ProfileAttribute[]{new ProfileAttribute(attributeName, conf.getType(), attributeValues)}).toList();
        return new ProfileAttributeBlock(null, (ImmutableList<ProfileAttribute>)attributes);
    }

    @CheckForNull
    public SetCommand<PersonImportModel<?>> getCommand(String personField) {
        return this._commandMap.get(personField);
    }
}

