/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.mapper;

import de.justsoftware.onx.migration.business.mapper.commands.DBEntityImportCommand;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommand;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommands;
import de.justsoftware.onx.migration.shared.server.model.EntityImportBean;
import de.justsoftware.onx.migration.shared.server.model.LDAPEntityImportModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFieldsMapper<T> {
    static final Logger LOG = LoggerFactory.getLogger(EntityFieldsMapper.class);
    private final Map<String, SetCommand<LDAPEntityImportModel<T>>> _commandMap = new HashMap<String, SetCommand<LDAPEntityImportModel<T>>>();

    public EntityFieldsMapper() {
        this._commandMap.put("entity.name", new DBEntityImportCommand<T>(){

            @Override
            protected void setValue(EntityImportBean<T> entity, List<Object> values, SetCommand.ParameterAccessor parameterAccess) {
                entity.setName(SetCommands.getSingleString(values));
            }
        });
    }

    @CheckForNull
    public SetCommand<LDAPEntityImportModel<T>> getCommand(@Nonnull String entityField) {
        return this._commandMap.get(entityField);
    }
}

