/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.UserGroupMembershipsImportPublisher;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class UserGroupMembershipsImportPostProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    private final UserGroupMembershipsImportPublisher _userGroupMembershipsImportPublisher;

    @Autowired
    public UserGroupMembershipsImportPostProcessor(UserGroupMembershipsImportPublisher userGroupMembershipsImportPublisher) {
        this._userGroupMembershipsImportPublisher = userGroupMembershipsImportPublisher;
    }

    @Override
    public void process(List<? extends I> importedPersons, ImportUpdateEventCollector importUpdateEventCollector) {
        for (PersonImportModel personImportModel : importedPersons) {
            try {
                ProfileId profileId = personImportModel.getPerson().getId().asProfileId();
                personImportModel.getAddedUserGroupMemberships().forEach(userGroupId -> this._userGroupMembershipsImportPublisher.addProfileIdToUserGroup(profileId, (UserGroupId)userGroupId));
                personImportModel.getRemovedUserGroupMemberships().forEach(userGroupId -> this._userGroupMembershipsImportPublisher.removeProfileIdFromUserGroup(profileId, (UserGroupId)userGroupId));
            }
            catch (RuntimeException e) {
                PersonImportService.IMPORT_LOG.error("Could not import groups for " + personImportModel.getExternalId(), (Throwable)e);
            }
        }
    }
}

