/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Supplier;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.JustImportApiConnector;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.UserGroupImportService;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

@ParametersAreNonnullByDefault
public class TriggerJustImportUserGroupImportService
implements UserGroupImportService,
JustImportApiConnector {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerJustImportUserGroupImportService.class);
    private final ImportResultMailService _mailService;
    private final RestOperations _restTemplate;
    private final String _importInternalApiUrl;
    private final Supplier<TenantId> _importTenantIdSupplier;
    private final MigrationSettings _settings;

    @Autowired
    public TriggerJustImportUserGroupImportService(ImportResultMailService mailService, @Qualifier(value="importRestTemplate") RestOperations restTemplate, @Value(value="${just-import.internalApi.url}") String importInternalApiUrl, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> importTenantIdSupplier, MigrationSettings settings) {
        this._mailService = mailService;
        this._restTemplate = restTemplate;
        this._importInternalApiUrl = importInternalApiUrl;
        this._importTenantIdSupplier = importTenantIdSupplier;
        this._settings = settings;
    }

    @Override
    public ImportStatistics importUserGroups() throws ImportException {
        if (!this.isEnabled()) {
            throw new ImportException("User group import is disabled");
        }
        PersonImportService.IMPORT_LOG.info("****** IMPORT STARTED ({}) *********", (Object)this.getClass().getSimpleName());
        ImportStatistics statistics = new ImportStatistics(DateTime.now());
        try {
            ImportResult importResult = (ImportResult)this._restTemplate.getForObject(this._importInternalApiUrl + "/import/userGroups/{tenantId}", ImportResult.class, new Object[]{this._importTenantIdSupplier.get()});
            this.mapImportResultToStatistics(statistics, importResult);
        }
        catch (RuntimeException e) {
            LOG.error("Error triggering just-import REST-API for {}/import/userGroups.", (Object)this._importInternalApiUrl, (Object)e);
            this._mailService.notifyImportFailed("Error importing user groups: " + e.getMessage());
            throw new ImportException(e);
        }
        finally {
            PersonImportService.IMPORT_LOG.info("****** IMPORT FINISHED ({}) *********", (Object)this.getClass().getSimpleName());
        }
        statistics.setEndTime(DateTime.now());
        return statistics;
    }

    @Override
    public boolean isEnabled() {
        return this._settings.isImportUserGroupsEnabled();
    }

    @Override
    @Nonnull
    public ImportStatistics doImport() {
        try {
            return this.importUserGroups();
        }
        catch (ImportException | RuntimeException e) {
            PersonImportService.IMPORT_LOG.error("Failed to trigger user group import", (Throwable)e);
            ImportStatistics emptyResult = new ImportStatistics(DateTime.now(), DateTime.now());
            emptyResult.incFailedImports();
            return emptyResult;
        }
    }

    private void mapImportResultToStatistics(ImportStatistics statistics, ImportResult importResult) {
        int processed = importResult.getSuccessfulGroups() + importResult.getSuccessfulMembers() + importResult.getErrors();
        statistics.incProcessed(processed);
        statistics.incFailedImports(importResult.getErrors());
        statistics.incSuccessfulImports(importResult.getSuccessfulGroups() + importResult.getSuccessfulMembers());
        statistics.incUpdated(importResult.getUpdatedGroups());
        statistics.incInserted(importResult.getInsertedGroups());
        statistics.incSkipped(importResult.getSkipped());
    }

    @Override
    public void checkHealth() {
        try {
            this._restTemplate.getForEntity(this._importInternalApiUrl + "/monitoring/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("Just import health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString().toString() + ")");
        }
    }

    static class ImportResult {
        private int _errors;
        private int _skipped;
        private int _insertedGroups;
        private int _successfulGroups;
        private int _successfulMembers;
        private int _updatedGroups;

        ImportResult() {
        }

        public int getSuccessfulMembers() {
            return this._successfulMembers;
        }

        public void setSuccessfulMembers(int successfulMembers) {
            this._successfulMembers = successfulMembers;
        }

        public int getSuccessfulGroups() {
            return this._successfulGroups;
        }

        public void setSuccessfulGroups(int successfulGroups) {
            this._successfulGroups = successfulGroups;
        }

        public int getInsertedGroups() {
            return this._insertedGroups;
        }

        public void setInsertedGroups(int insertedGroups) {
            this._insertedGroups = insertedGroups;
        }

        public int getUpdatedGroups() {
            return this._updatedGroups;
        }

        public void setUpdatedGroups(int updatedGroups) {
            this._updatedGroups = updatedGroups;
        }

        public int getErrors() {
            return this._errors;
        }

        public void setErrors(int errors) {
            this._errors = errors;
        }

        public int getSkipped() {
            return this._skipped;
        }

        public void setSkipped(int skipped) {
            this._skipped = skipped;
        }
    }
}

