/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.person.business.PersonRoleService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

public class StaticRoleImportPostProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    private final StaticRoleImportDataProvider<I> _noopDataProvider = importedData -> ImmutableList.of();
    private StaticRoleImportDataProvider<I> _importDataProvider = this._noopDataProvider;
    private boolean _overrideExisting = true;
    private final PersonRoleService _personRoleService;
    private final ConfigFileService _configFileService;
    private final MigrationSettings _migrationSettings;

    @ParametersAreNonnullByDefault
    @Autowired
    public StaticRoleImportPostProcessor(PersonRoleService personRoleService, ConfigFileService configFileService, MigrationSettings migrationSettings) {
        this._personRoleService = personRoleService;
        this._configFileService = configFileService;
        this._migrationSettings = migrationSettings;
    }

    public void setOverrideExisting(boolean overrideExisting) {
        this._overrideExisting = overrideExisting;
    }

    public void setImportDataProvider(@Nonnull StaticRoleImportDataProvider<I> importDataProvider) {
        this._importDataProvider = importDataProvider;
    }

    @Override
    public void process(List<? extends I> importedPersons, ImportUpdateEventCollector importUpdateEventCollector) {
        if (!this._overrideExisting && this._importDataProvider == this._noopDataProvider && this.getConfiguredDefaultRoles().isEmpty()) {
            return;
        }
        try {
            HashMultimap importedRoles = HashMultimap.create();
            for (StaticRoleImportModel roleImportModel : this._importDataProvider.getAdditionalImportDataFor(importedPersons)) {
                roleImportModel.getRoleAssignments().forEach((arg_0, arg_1) -> StaticRoleImportPostProcessor.lambda$process$1((SetMultimap)importedRoles, arg_0, arg_1));
            }
            ImmutableSet importedPersonIds = (ImmutableSet)importedPersons.stream().map(PersonImportModel.TO_PERSON_ID).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            ImmutableSet<PersonRole> importDefaultStaticRoles = this.getConfiguredDefaultRoles();
            if (!importDefaultStaticRoles.isEmpty()) {
                importedPersonIds.forEach(arg_0 -> StaticRoleImportPostProcessor.lambda$process$2((SetMultimap)importedRoles, importDefaultStaticRoles, arg_0));
            }
            ImmutableSetMultimap<PersonId, PersonRole> existingRoles = this._personRoleService.getPersonRoles((Set<PersonId>)importedPersonIds);
            for (PersonId importedPersonId : importedPersonIds) {
                this.importRoles(importedPersonId, (Set<PersonRole>)existingRoles.get((Object)importedPersonId), importedRoles.get((Object)importedPersonId), importUpdateEventCollector);
            }
        }
        catch (ImportException e) {
            PersonImportService.IMPORT_LOG.error("Error occured while importing static roles. Role import aborted for this chunk.", (Throwable)e);
        }
    }

    private ImmutableSet<PersonRole> getConfiguredDefaultRoles() {
        return (ImmutableSet)this._migrationSettings.getImportDefaultStaticRoles().stream().map(PersonRole::valueOf).collect(ImmutableSet.toImmutableSet());
    }

    private void importRoles(@Nonnull PersonId personId, @Nonnull Set<PersonRole> personRoles, @Nonnull Set<PersonRole> importedRoles, @Nonnull ServerEventCollector serverEventCollector) {
        boolean updateRequired;
        Set<PersonRole> validImportedRoles = this.extractValidRoles(importedRoles, personId);
        boolean bl = this._overrideExisting ? !validImportedRoles.equals(personRoles) : (updateRequired = !Sets.difference(validImportedRoles, personRoles).isEmpty());
        if (updateRequired) {
            try {
                this._personRoleService.savePersonRoles(personId, validImportedRoles, this._overrideExisting, serverEventCollector);
                PersonImportService.IMPORT_LOG.info("Sucessfully saved roles {} for person id {}", importedRoles, (Object)personId);
            }
            catch (DAOException e) {
                PersonImportService.IMPORT_LOG.error("Could not save roles " + importedRoles + " for person id " + personId, (Throwable)e);
            }
        } else {
            PersonImportService.IMPORT_LOG.info("No Just Connect roles found. Skipping role import for person {}", (Object)personId);
        }
    }

    @Nonnull
    private Set<PersonRole> extractValidRoles(@Nonnull Set<PersonRole> importedRoles, @Nonnull PersonId personId) {
        Sets.SetView invalidRoles = Sets.difference(importedRoles, this._configFileService.getConfigFile().getAllPersonRoles());
        if (invalidRoles.isEmpty()) {
            return importedRoles;
        }
        PersonImportService.IMPORT_LOG.error("Skip saving invalid roles for person id {}: {}", (Object)personId, (Object)invalidRoles);
        HashSet validRoles = Sets.newHashSet(importedRoles);
        validRoles.removeAll((Collection<?>)invalidRoles);
        return validRoles;
    }

    private static /* synthetic */ void lambda$process$2(SetMultimap importedRoles, ImmutableSet importDefaultStaticRoles, PersonId personId) {
        importedRoles.putAll((Object)personId, (Iterable)importDefaultStaticRoles);
    }

    private static /* synthetic */ void lambda$process$1(SetMultimap importedRoles, PersonId person, String rolename) {
        importedRoles.put((Object)person, (Object)PersonRole.valueOf(rolename));
    }

    public static class StaticRoleImportModel {
        private final ImmutableSetMultimap<PersonId, String> _roleAssignments;

        public StaticRoleImportModel(@Nonnull ImmutableSet<PersonId> personIds, @Nonnull ImmutableSet<String> roleNames) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (PersonId personId : personIds) {
                builder.putAll((Object)personId, roleNames);
            }
            this._roleAssignments = builder.build();
        }

        @Nonnull
        public ImmutableSetMultimap<PersonId, String> getRoleAssignments() {
            return this._roleAssignments;
        }
    }

    public static interface StaticRoleImportDataProvider<J extends PersonImportModel<?>>
    extends ImportProcessor.ImportDataProvider<J, StaticRoleImportModel> {
    }
}

