/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.migration.business.impl.ExternalIdentificationPersonImportProcessor;
import de.justsoftware.onx.migration.business.impl.LDAPExactValueExtractor;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class SimpleFieldExternalIdPersonImportDataProvider<I extends PersonImportModel<?>>
implements ExternalIdentificationPersonImportProcessor.ExternalIdentificationImportDataProvider<I> {
    private LDAPExactValueExtractor _valueExtractor;
    private String _fieldname;

    @Required
    public void setExternalIdFieldName(@Nonnull String fieldname) {
        this._fieldname = fieldname;
        this._valueExtractor = new LDAPExactValueExtractor();
        this._valueExtractor.setAttributeFieldName(this._fieldname);
    }

    @Override
    public Iterable<ExternalIdentificationPersonImportProcessor.ExternalIdImportModel> getAdditionalImportDataFor(List<? extends I> importedData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PersonImportModel personImportModel : importedData) {
            ExternalIdentificationPersonImportProcessor.ExternalIdImportModel externalIdImportModel = this.getAdditionalImportDataFor(personImportModel);
            if (externalIdImportModel == null) continue;
            builder.add((Object)externalIdImportModel);
        }
        return builder.build();
    }

    @CheckForNull
    ExternalIdentificationPersonImportProcessor.ExternalIdImportModel getAdditionalImportDataFor(@Nonnull PersonImportModel<?> personImportModel) {
        String externalId = personImportModel.accept(new PersonImportModelVisitor<String>(){

            @Override
            public String visitCSVPersonImportModel(CSVPersonImportModel importModel) {
                return importModel.getRow().get(SimpleFieldExternalIdPersonImportDataProvider.this._fieldname);
            }

            @Override
            public String visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
                return (String)Iterables.getFirst(SimpleFieldExternalIdPersonImportDataProvider.this._valueExtractor.getValues(importModel.getAttributes()), null);
            }

            @Override
            public String visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
                Object value = importModel.getDataRow().get(SimpleFieldExternalIdPersonImportDataProvider.this._fieldname);
                return value != null ? value.toString() : null;
            }

            @Override
            public String visitGenericPersonImportModel(GenericPersonImportModel importModel) {
                return importModel.getPersonField(SimpleFieldExternalIdPersonImportDataProvider.this._fieldname);
            }
        });
        return externalId != null ? new ExternalIdentificationPersonImportProcessor.ExternalIdImportModel(personImportModel.getPerson().getId(), new ExternalPersonId(externalId)) : null;
    }
}

