/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.MembershipImportService;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class SequentialMultiMembershipImportServiceImpl
implements MembershipImportService {
    private final List<MembershipImportService> _services;
    private final Clock _clock;
    private final ImportProcessLockService _importProcessLockService;

    @Autowired
    public SequentialMultiMembershipImportServiceImpl(@Nonnull List<MembershipImportService> services, ImportProcessLockService importProcessLockService, Clock clock) {
        this._services = services;
        this._importProcessLockService = importProcessLockService;
        this._clock = clock;
    }

    @Override
    public void importMemberships() throws ImportException {
        this._importProcessLockService.acquireAndExecute(this::doImport);
    }

    @Override
    public ImportStatistics doImport() {
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        for (MembershipImportService importService : this._services) {
            ImportStatistics result = importService.doImport();
            statistics = statistics.merge(result);
        }
        return statistics;
    }
}

