/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.server.util.FileUtils;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.toolbox.clock.Clock;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

public class ProfileDocumentUploadPostProcessor
implements ImportPostProcessor<PersonImportModel<?>> {
    public static final String ID_PARAM_PATTERN = "\\{ID\\}";
    private final EntityService _entityService;
    private final Clock _clock;
    private final DriveInternalApiConnector _driveInternalApiConnector;
    private final TenantId _tenantId;
    private String _fileFilterPattern;
    private String _entityNamePattern;
    private File _directory;
    private EntityType _entityType;
    private boolean _createEntity = true;
    private EntityId _parentEntityId;
    private boolean _moveUploadedFile = true;
    private File _moveUploadedFileTargetDir;

    @ParametersAreNonnullByDefault
    @Autowired
    public ProfileDocumentUploadPostProcessor(EntityService entityService, Clock clock, DriveInternalApiConnector driveInternalApiConnector, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> importTenantIdSupplier) {
        this._entityService = entityService;
        this._clock = clock;
        this._driveInternalApiConnector = driveInternalApiConnector;
        this._tenantId = (TenantId)importTenantIdSupplier.get();
    }

    @Required
    public void setFileFilterPattern(@Nonnull String fileFilterPattern) {
        this._fileFilterPattern = StringUtils.trimToEmpty((String)fileFilterPattern);
    }

    @Required
    public void setEntityNamePattern(@Nonnull String entityNamePattern) {
        this._entityNamePattern = StringUtils.trimToEmpty((String)entityNamePattern);
    }

    @Required
    public void setDirectory(@Nonnull File directory) {
        this._directory = directory;
    }

    @Required
    public void setEntityType(@Nonnull String entityType) {
        this._entityType = EntityType.valueOf(entityType);
    }

    public void setCreateEntity(boolean createEntity) {
        this._createEntity = createEntity;
    }

    public void setParentEntityId(@Nullable Long parentEntityId) {
        this._parentEntityId = EntityId.valueOf(parentEntityId);
    }

    public void setMoveUploadedFile(boolean moveUploadedFile) {
        this._moveUploadedFile = moveUploadedFile;
    }

    public void setMoveUploadedFileTargetDir(@Nonnull File movedUploadedFileDir) {
        this._moveUploadedFileTargetDir = movedUploadedFileDir;
    }

    @Override
    public void process(List<? extends PersonImportModel<?>> importModel, ImportUpdateEventCollector importUpdateEventCollector) {
        File dir = this._directory;
        if (dir.exists() && dir.isDirectory() && dir.canRead()) {
            PersonImportService.IMPORT_LOG.info("Starting to import profile documents ...");
            for (PersonImportModel<?> personImportModel : importModel) {
                try {
                    this.processSingleModel(personImportModel, importUpdateEventCollector);
                }
                catch (ServiceException e) {
                    PersonImportService.IMPORT_LOG.error("Service error occured while importing person " + personImportModel.getExternalId(), (Throwable)e);
                }
                catch (DAOException e) {
                    PersonImportService.IMPORT_LOG.error("DAO error occured while importing person " + personImportModel.getExternalId(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    PersonImportService.IMPORT_LOG.error("General error occured while importing person " + personImportModel.getExternalId(), (Throwable)e);
                }
            }
            PersonImportService.IMPORT_LOG.info("Finished to import profile documents");
        } else {
            PersonImportService.IMPORT_LOG.error("Directory {} is not accessible. Aborting import", (Object)dir.getName());
        }
    }

    @ParametersAreNonnullByDefault
    private void processSingleModel(PersonImportModel<?> importedPerson, ImportUpdateEventCollector importUpdateEventCollector) {
        PersonId personId = importedPerson.getPerson().getId();
        String externalId = importedPerson.accept(GetExternalIdVisitor.INSTANCE);
        if (externalId == null) {
            PersonImportService.IMPORT_LOG.error("No external id provided. Aborting document import for " + personId);
            return;
        }
        FilenameFilter fileNameFilter = this.createFilenameFilter(externalId);
        File[] filesForUpload = this._directory.listFiles(fileNameFilter);
        if (filesForUpload == null || filesForUpload.length == 0) {
            PersonImportService.IMPORT_LOG.info("No documents found for person {}", (Object)personId);
            return;
        }
        EntityId docParentId = this.getDocumentParentId(externalId);
        if (docParentId == null) {
            if (!this._createEntity) {
                PersonImportService.IMPORT_LOG.error("Could neither find nor create document parent id for uploading documents for person {}", (Object)externalId);
                return;
            }
            docParentId = this.createEntity(personId, externalId, importUpdateEventCollector);
        }
        for (File file : filesForUpload) {
            try {
                this._driveInternalApiConnector.replaceFile(docParentId, file, personId, DriveChangePurpose.IMPORT);
                this.moveFile(file);
            }
            catch (ServiceException e) {
                PersonImportService.IMPORT_LOG.warn("Unable to upload file " + file + " for Person " + personId + " into Rootfolder of " + docParentId, (Throwable)e);
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private EntityId createEntity(PersonId internalId, String externalId, ImportUpdateEventCollector importUpdateEventCollector) {
        String name = this.createEntityName(externalId);
        PersonImportService.IMPORT_LOG.info("Starting to create new entity with name {}, type {} and parent id {} for person id {} with external id {}", new Object[]{name, this._entityType, this._parentEntityId, internalId, externalId});
        DBEntity entity = new DBEntity();
        if (this._parentEntityId != null) {
            DBEntityLink parent = new DBEntityLink();
            parent.setLinkedEntityId(this._parentEntityId);
            entity.setLinkedEntities((List<DBEntityLink>)ImmutableList.of((Object)parent));
        }
        entity.setName(name);
        entity.setType(this._entityType);
        EntityId id = this._entityService.createEntity(entity, null, null, (ImmutableList<DynamicAttributeEditModel>)ImmutableList.of(), new EverythingAllowedAuthorizationCheckContextWithUserId(internalId, this._tenantId, "de"), false);
        importUpdateEventCollector.add(new EntityUpdateEvent(id));
        return id;
    }

    private void moveFile(@Nonnull File file) {
        File targetDir = this._moveUploadedFileTargetDir;
        if (this._moveUploadedFile && targetDir != null) {
            try {
                FileUtils.moveFileToDir(file, targetDir, true, this._clock);
                PersonImportService.IMPORT_LOG.info("Successfully moved file {} to dir {}", (Object)file.getName(), (Object)targetDir.getAbsolutePath());
            }
            catch (IOException e) {
                PersonImportService.IMPORT_LOG.error("Could not move file " + file.getName(), (Throwable)e);
            }
        } else {
            PersonImportService.IMPORT_LOG.info("File moval not activated. Not moving " + file.getName());
        }
    }

    @CheckForNull
    private EntityId getDocumentParentId(String externalId) {
        String entityName = this.createEntityName(externalId);
        return this._entityService.getIdByNameAndType(entityName, this._entityType);
    }

    @Nonnull
    private FilenameFilter createFilenameFilter(String externalId) {
        String fileFilter = this._fileFilterPattern.replaceAll(ID_PARAM_PATTERN, externalId);
        return new WildcardFileFilter(fileFilter);
    }

    @Nonnull
    @VisibleForTesting
    public String createEntityName(String externalId) {
        return this._entityNamePattern.replaceAll(ID_PARAM_PATTERN, StringUtils.trimToEmpty((String)externalId));
    }

    private static enum GetExternalIdVisitor implements PersonImportModelVisitor<String>
    {
        INSTANCE;


        @Override
        public String visitCSVPersonImportModel(CSVPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
            return importModel.getExternalIdWithoutDomain();
        }

        @Override
        public String visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitGenericPersonImportModel(GenericPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }
    }
}

