/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.integration.persistence.LanguageDAO;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.AbstractImportServiceImpl;
import de.justsoftware.onx.migration.business.impl.DatePersonImportModelVisitor;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.mapper.PersonFieldsMapper;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommand;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.person.business.PersonExternalIdPublisher;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonWriteDataService;
import de.justsoftware.onx.person.business.events.PersonDataChangedEventByImport;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.business.ProfileWriteDataService;
import de.justsoftware.onx.profile.business.events.ProfileAttributesChangedEvent;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.security.service.MobileLogoutService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@ParametersAreNonnullByDefault
public class PersonImportServiceImpl<M extends PersonImportModel<String>>
extends AbstractImportServiceImpl<M>
implements PersonImportService {
    private final PersonDAO _personDAO;
    private final LanguageDAO _langDAO;
    private final PersonWriteDataService _personWriteDataService;
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final Settings _settings;
    private final ProfileReadDataService _profileReadDataService;
    private final ProfileWriteDataService _profileWriteDataService;
    private final TransactionHelper _transactionHelper;
    private final PersonExternalIdPublisher _personExternalIdPublisher;
    private final MobileLogoutService _mobileLogoutService;
    private final JucoPasswordEncoder _passwordEncoder;
    private final Supplier<TenantId> _importTenantIdSupplier;
    private final PersonTenantService _personTenantService;
    private PersonImportDataProvider<M> _dataProvider;
    private PersonImportMode _personImportMode = PersonImportMode.DELETE_ATTRIBUTES;
    private boolean _activateNewUser = true;
    private boolean _acceptTermsForNewUser = false;
    private boolean _reimportDeletedUsers = true;
    private boolean _updateModifyDate = false;
    private String _modifyDateFieldName = "modifyTimestamp";
    private String _modifyDateFormat = "yyyyMMddHHmmssZ";
    private boolean _checkImportSourceModifyDate = false;

    @Autowired
    public PersonImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, PersonDAO personDAO, LanguageDAO languageDAO, PersonWriteDataService personWriteDataService, PersonImportMappingDAO personImportMappingDAO, Settings settings, ProfileReadDataService profileReadDataService, ProfileWriteDataService profileWriteDataService, TransactionHelper transactionHelper, PersonExternalIdPublisher personExternalIdPublisher, MobileLogoutService mobileLogoutService, JucoPasswordEncoder passwordEncoder, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> importTenantIdSupplier, PersonTenantService personTenantService, ImportProcessLockService importProcessLockService) {
        super(personService, updateEventHandler, eventBus, clock, importResultMailService, importProcessLockService);
        this._personDAO = personDAO;
        this._langDAO = languageDAO;
        this._personWriteDataService = personWriteDataService;
        this._personImportMappingDAO = personImportMappingDAO;
        this._settings = settings;
        this._profileReadDataService = profileReadDataService;
        this._profileWriteDataService = profileWriteDataService;
        this._transactionHelper = transactionHelper;
        this._personExternalIdPublisher = personExternalIdPublisher;
        this._mobileLogoutService = mobileLogoutService;
        this._passwordEncoder = passwordEncoder;
        this._importTenantIdSupplier = importTenantIdSupplier;
        this._personTenantService = personTenantService;
    }

    public void setModifyDateFieldName(String fieldName) {
        this._modifyDateFieldName = fieldName;
    }

    public void setModifyDateFormat(String format) {
        this._modifyDateFormat = format;
    }

    public void setCheckImportSourceModifyDate(boolean checkImportSourceModifyDate) {
        this._checkImportSourceModifyDate = checkImportSourceModifyDate;
    }

    public void setImportMode(PersonImportMode personImportMode) {
        this._personImportMode = personImportMode;
    }

    public void setActivateNewUser(boolean activateNewUser) {
        this._activateNewUser = activateNewUser;
    }

    public void setAcceptTermsForNewUser(boolean acceptTermsForNewUser) {
        this._acceptTermsForNewUser = acceptTermsForNewUser;
    }

    @Required
    public void setImportDataProvider(PersonImportDataProvider<M> dataProvider) {
        this._dataProvider = dataProvider;
    }

    public void setReimportDeletedUsers(boolean reimportDeletedUsers) {
        this._reimportDeletedUsers = reimportDeletedUsers;
    }

    public void setUpdateModifyDate(boolean updateModifyDate) {
        this._updateModifyDate = updateModifyDate;
    }

    @Override
    protected void initBeforeImport() {
    }

    @Override
    protected void cleanUpAfterImport() {
        this._personWriteDataService.invalidateUpcommingBirthdays();
    }

    @Override
    public boolean isEnabled() {
        return this._settings.isImportPersonsEnabled();
    }

    @Override
    protected Iterable<List<M>> getImportModels(ImportStatistics statistics) throws ImportException {
        return this._dataProvider.getImportModels(statistics);
    }

    @Override
    public ImportStatistics importPersons() throws ImportException {
        return this._importProcessLockService.acquireAndExecute(this::doImport);
    }

    protected void setImportedValues(final PersonImportModel<?> importModel, Set<String> importedFieldNames) {
        PersonFieldsMapper mapper = new PersonFieldsMapper(this._passwordEncoder);
        mapper.addDynamicAttributeCommands(this._profileReadDataService.getAttributesConfiguration());
        for (final String personField : importedFieldNames) {
            SetCommand<PersonImportModel<?>> command = mapper.getCommand(personField);
            if (command == null) continue;
            List values = importModel.getImportedValues().get((Object)personField);
            if (IMPORT_LOG.isDebugEnabled()) {
                String msg = "Setting " + personField + " with values: " + values + " of person " + importModel.getExternalId();
                IMPORT_LOG.debug(msg);
            }
            command.set(importModel, values, new SetCommand.ParameterAccessor(){

                @Override
                public String getParameter(String parameterName) {
                    return importModel.getFieldParameter(personField, parameterName);
                }

                @Override
                public boolean synchronize() {
                    return PersonImportServiceImpl.this._personImportMode == PersonImportMode.DELETE_ATTRIBUTES;
                }
            });
        }
    }

    @Override
    protected List<M> processBatch(List<? extends M> importModels, ImportStatistics statistics, ImportUpdateEventCollector eventCollector) throws ImportException {
        DateTime importStartTime = this._clock.now();
        ArrayList toPostProcess = Lists.newArrayList();
        Set<String> importedFieldNames = this._dataProvider.getImportedFieldNames();
        for (PersonImportModel importResult : importModels) {
            try {
                Set<String> preProcessedFieldNames = importResult.getPreProcessedFieldNames();
                ImmutableSet fieldNames = ImmutableSet.copyOf((Iterable)Iterables.concat(importedFieldNames, preProcessedFieldNames));
                PersonImportModel importedModel = this.processImportModel(importResult, (Set<String>)fieldNames, statistics, eventCollector, importStartTime);
                if (importedModel == null) continue;
                toPostProcess.add(importedModel);
            }
            catch (RuntimeException ex) {
                IMPORT_LOG.error("Import of " + (String)importResult.getExternalId() + " failed", (Throwable)ex);
                statistics.incFailed(ImportStatistics.ImportErrorType.EXCEPTION, importResult.getImportedEmail());
            }
        }
        return toPostProcess;
    }

    @CheckForNull
    protected M processImportModel(M importResult, ImportStatistics statistics, ImportUpdateEventCollector eventCollector) throws ImportException {
        DateTime importStartTime = this._clock.now();
        Set<String> importedFieldNames = this._dataProvider.getImportedFieldNames();
        Set<String> preProcessedFieldNames = ((PersonImportModel)importResult).getPreProcessedFieldNames();
        ImmutableSet fieldNames = ImmutableSet.copyOf((Iterable)Iterables.concat(importedFieldNames, preProcessedFieldNames));
        return this.processImportModel(importResult, (Set<String>)fieldNames, statistics, eventCollector, importStartTime);
    }

    @CheckForNull
    private M processImportModel(M importResult, Set<String> importedFieldNames, ImportStatistics statistics, ImportUpdateEventCollector eventCollector, DateTime importStartTime) {
        String importedEmail = ((PersonImportModel)importResult).getImportedEmail();
        try {
            boolean updateAllowed;
            boolean isNewPerson;
            DBPerson person = this.determineDBPerson((PersonImportModel<String>)importResult, statistics);
            if (person != null && person.isDeleted()) {
                if (!this._reimportDeletedUsers) {
                    IMPORT_LOG.info("Person " + importedEmail + " is deleted in Just Connect. Skipping this person.");
                    statistics.incSkipped(ImportStatistics.ImportErrorType.DELETED_IN_JUST, importedEmail);
                    return null;
                }
                this._personImportMappingDAO.removeIdMapping(person.getId());
                this._personExternalIdPublisher.deleteMapping(person.getId());
            }
            boolean wasActive = person != null && !person.isDeleted() && person.isActive();
            boolean wasBlocked = person != null && person.isBlocked();
            Date lastImportDate = person == null ? null : this._personImportMappingDAO.getImportDate(person.getId());
            boolean bl = isNewPerson = person == null || person.isDeleted();
            if (isNewPerson) {
                person = new DBPerson();
            }
            ((PersonImportModel)importResult).setPerson(person);
            boolean bl2 = updateAllowed = this._personImportMode != PersonImportMode.INSERT_ATTRIBUTES_ONLY;
            if (isNewPerson || updateAllowed) {
                this.setImportedValues((PersonImportModel<?>)importResult, importedFieldNames);
                DBPerson importedPerson = ((PersonImportModel)importResult).getPerson();
                if (!this.validate(importedPerson, (String)((PersonImportModel)importResult).getExternalId(), statistics)) {
                    return null;
                }
                this.doImport((PersonImportModel<String>)importResult, statistics, eventCollector, importStartTime, wasActive, wasBlocked, lastImportDate, isNewPerson);
            } else {
                statistics.incSkipped();
            }
            ((PersonImportModel)importResult).setNew(isNewPerson);
            return importResult;
        }
        catch (ServiceException | DAOException e) {
            IMPORT_LOG.error("Error occured while importing person " + importedEmail, (Throwable)e);
            statistics.incFailed(ImportStatistics.ImportErrorType.EXCEPTION, importedEmail);
            return null;
        }
    }

    private void doImport(PersonImportModel<String> importResult, ImportStatistics statistics, ImportUpdateEventCollector eventCollector, DateTime importStartTime, boolean wasActive, boolean wasBlocked, @Nullable Date lastImportDate, boolean isNewPerson) {
        DateTime modifyDate = importResult.accept(new DatePersonImportModelVisitor(this._modifyDateFieldName, this._modifyDateFormat));
        if (!this._checkImportSourceModifyDate || lastImportDate == null || modifyDate == null || modifyDate.isAfter((ReadableInstant)new DateTime((Object)lastImportDate))) {
            DBPerson person = importResult.getPerson();
            if (isNewPerson) {
                this.insertNewPerson(importResult, modifyDate == null ? importStartTime : modifyDate);
                statistics.incInserted();
            } else {
                this.updatePerson(importResult, person.getId(), modifyDate == null ? importStartTime : modifyDate);
                statistics.incUpdated();
            }
            this.fireUpdateEvents(wasActive, wasBlocked, person, eventCollector);
        } else {
            statistics.incSkipped();
        }
    }

    private void fireUpdateEvents(boolean wasActive, boolean wasBlocked, DBPerson person, ImportUpdateEventCollector eventCollector) {
        PersonId personId = person.getId();
        boolean isActive = person.isActive();
        boolean isBlocked = person.isBlocked();
        eventCollector.add(new PersonDataChangedEventByImport(personId));
        eventCollector.add(new ProfileAttributesChangedEvent(personId));
        if (wasActive != isActive) {
            if (isActive) {
                this._personService.notifyPersonActivated(personId, eventCollector);
            } else {
                this._personService.notifyPersonDeactivated(personId, eventCollector);
            }
        }
        if (wasBlocked != isBlocked) {
            this._personService.notifyPersonBlocked(personId, isBlocked, eventCollector);
        }
    }

    @CheckForNull
    private DBPerson determineDBPerson(PersonImportModel<String> importResult, ImportStatistics statistics) {
        String externalId = importResult.getExternalId();
        String fallbackExternalId = importResult.getFallbackExternalId();
        PersonId dbPersonId = this._personImportMappingDAO.getInternalId(externalId);
        if (dbPersonId == null && fallbackExternalId != null) {
            dbPersonId = this._personImportMappingDAO.getInternalId(fallbackExternalId);
        }
        String importedEmail = importResult.getImportedEmail();
        if (dbPersonId == null && importedEmail != null && (dbPersonId = (PersonId)this._personDAO.getPersonIdsByEmails((Set<String>)ImmutableSet.of((Object)importedEmail)).get((Object)importedEmail)) != null) {
            IMPORT_LOG.info("Using email to map imported person with external id " + externalId + " to person.id " + dbPersonId);
        }
        if (dbPersonId == null) {
            return null;
        }
        DBPerson person = (DBPerson)this._personDAO.getPersonsByIds((Set<? extends PersonId>)ImmutableSet.of((Object)dbPersonId)).get((Object)dbPersonId);
        if (person == null) {
            IMPORT_LOG.error("The person " + externalId + " has a not existing internal id assigned: " + dbPersonId + ". Person will not be imported.");
            statistics.incFailed(ImportStatistics.ImportErrorType.INVALID_INTERNAL_ID, externalId);
        }
        return person;
    }

    private boolean validate(DBPerson importedPerson, String externalId, ImportStatistics statistics) {
        String email = importedPerson.getEmail();
        if (email == null) {
            IMPORT_LOG.warn("The person " + importedPerson.getFullName() + " (external id " + externalId + ") could not be imported, since they have no email address assigned.");
            statistics.incFailed(ImportStatistics.ImportErrorType.MISSING_EMAIL, externalId);
            return false;
        }
        String firstname = importedPerson.getFirstName();
        if (firstname == null) {
            IMPORT_LOG.warn("The person with email " + email + " (external id " + externalId + ") could not be imported, since they have no firstname assigned.");
            statistics.incFailed(ImportStatistics.ImportErrorType.MISSING_FIRSTNAME, externalId);
            return false;
        }
        String lastname = importedPerson.getLastName();
        if (lastname == null) {
            IMPORT_LOG.warn("The person with email " + email + " (external id " + externalId + ") could not be imported, since they have no lastname assigned.");
            statistics.incFailed(ImportStatistics.ImportErrorType.MISSING_LASTNAME, externalId);
            return false;
        }
        String importedLanguage = importedPerson.getLanguageId();
        if (importedLanguage == null || this._langDAO.getById(importedLanguage) == null) {
            if (importedLanguage != null) {
                IMPORT_LOG.warn("lang field has an invalid value: " + importedLanguage + ". Setting to system default.");
            }
            importedPerson.setLanguageId(this._settings.defaultLanguage());
        }
        return true;
    }

    private void setDefaultMandatoryValuesIfEmpty(PersonImportModel<String> importResult) {
        String saltedPasswordHash;
        DBPerson person = importResult.getPerson();
        if (importResult.isActive() == null) {
            importResult.setActive(this._activateNewUser);
        }
        if (person.getTermsAccepted() == null) {
            person.setTermsAccepted(this._acceptTermsForNewUser);
        }
        if (importResult.isBlocked() == null) {
            person.setBlocked(Boolean.FALSE);
        }
        if ((saltedPasswordHash = person.getPasswordHash()) == null) {
            String plainPassword = RandomStringUtils.random((int)12, (boolean)true, (boolean)true);
            person.setPasswordHash(this._passwordEncoder.encode(plainPassword));
            importResult.setPlainPassword(plainPassword);
        }
    }

    private void insertNewPerson(final PersonImportModel<String> importResult, final DateTime modifyDate) {
        this.setDefaultMandatoryValuesIfEmpty(importResult);
        final DBPerson importedPerson = importResult.getPerson();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                PersonId importedPersonId = PersonImportServiceImpl.this._personWriteDataService.insertPerson(importedPerson, PersonImportServiceImpl.this._clock.now());
                importedPerson.setId(importedPersonId);
                PersonImportServiceImpl.this._personTenantService.addPersonToTenant(importedPersonId, PersonImportServiceImpl.this._importTenantIdSupplier.get());
                PersonImportServiceImpl.this._personImportMappingDAO.insertIdMapping(importedPersonId, (String)importResult.getExternalId(), modifyDate.toDate());
                PersonImportServiceImpl.this._personExternalIdPublisher.publishMapping(importedPersonId, (String)importResult.getExternalId());
                if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
                    PersonImportService.IMPORT_LOG.info("Imported new person (" + (String)importResult.getExternalId() + ") with personId " + importedPersonId);
                }
                PersonImportServiceImpl.this.mergeProfileAttributes(importResult, importedPersonId);
            }
        });
    }

    private void updatePerson(final PersonImportModel<String> importResult, final PersonId dbPersonId, final DateTime modifyDate) {
        final DBPerson importedPerson = importResult.getPerson();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                PersonImportServiceImpl.this._personDAO.updatePerson(importedPerson, PersonImportServiceImpl.this._updateModifyDate ? modifyDate : null);
                PersonImportService.IMPORT_LOG.info("Updated profile data of " + importedPerson.getId());
                PersonImportServiceImpl.this.mergeProfileAttributes(importResult, dbPersonId);
                PersonImportServiceImpl.this._personImportMappingDAO.removeIdMapping(dbPersonId);
                PersonImportServiceImpl.this._personImportMappingDAO.insertIdMapping(dbPersonId, (String)importResult.getExternalId(), modifyDate.toDate());
                PersonImportServiceImpl.this._personExternalIdPublisher.publishMapping(dbPersonId, (String)importResult.getExternalId());
            }
        });
        if (!importedPerson.canLogin()) {
            this._mobileLogoutService.logoutFromMobileDevices(dbPersonId);
        }
        this._personWriteDataService.deleteFromCache(dbPersonId);
    }

    private void mergeProfileAttributes(PersonImportModel<String> importResult, PersonId dbPersonId) {
        for (Map.Entry<String, ProfileAttributeBlock> entry : importResult.getProfileAttributeBlocks().entrySet()) {
            this._profileWriteDataService.mergeProfileAttributeBlock(dbPersonId.asProfileId(), entry.getKey(), entry.getValue());
        }
    }

    public static enum PersonImportMode {
        INSERT_ATTRIBUTES_ONLY,
        UPDATE_NON_EMPTY_ATTRIBUTES,
        DELETE_ATTRIBUTES;

    }

    @ParametersAreNonnullByDefault
    public static interface WithFieldMappingFile {
        public void setFieldsMappingFile(String var1);

        @Nonnull
        public String getFieldsMappingFile();
    }

    @ParametersAreNonnullByDefault
    public static interface PersonImportDataProvider<M extends PersonImportModel<?>> {
        @Nonnull
        public Iterable<List<M>> getImportModels(ImportStatistics var1) throws ImportException;

        @Nonnull
        public Set<String> getImportedFieldNames() throws ImportException;
    }
}

