/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.freiheit.toro.common.integration.persistence.LanguageDAO;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowImportService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonDataImportService;
import de.justsoftware.onx.migration.business.UserGroupMembershipsImportPublisher;
import de.justsoftware.onx.migration.business.impl.GenericPersonImportDataProvider;
import de.justsoftware.onx.migration.business.impl.GenericRoleImportDataProvider;
import de.justsoftware.onx.migration.business.impl.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.NewUserGreetingImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.NonLockingImportProcessLockService;
import de.justsoftware.onx.migration.business.impl.PassiveSubscriptionImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.PersonImportServiceImpl;
import de.justsoftware.onx.migration.business.impl.RecommendedSubscriptionImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.StaticRoleImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.SubscriptionImportPostProcessor;
import de.justsoftware.onx.migration.business.impl.UserGroupMembershipsImportPostProcessor;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.business.model.PersonMembershipData;
import de.justsoftware.onx.migration.business.model.PersonSubscriptionData;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.person.business.PersonExternalIdPublisher;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonWriteDataService;
import de.justsoftware.onx.person.business.RegistrationService;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.business.ProfileWriteDataService;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.security.service.MobileLogoutService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonDataImportServiceImpl
implements PersonDataImportService {
    private static final Logger LOG = LoggerFactory.getLogger(PersonDataImportServiceImpl.class);
    private final UpdateEventHandler _updateHandler;
    private final JCEventBus _eventBus;
    private final PersonService _personService;
    private final PersonRoleService _personRoleService;
    private final Clock _clock;
    private final ImportResultMailService _importResultMailService;
    private final PersonDAO _personDAO;
    private final LanguageDAO _languageDAO;
    private final MobileLogoutService _mobileLogoutService;
    private final PersonWriteDataService _personWriteDataService;
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final Settings _settings;
    private final ProfileReadDataService _profileReadDataService;
    private final ProfileWriteDataService _profileWriteDataService;
    private final TransactionHelper _transactionHelper;
    private final PersonExternalIdPublisher _personExternalIdPublisher;
    private final EntityService _entityService;
    private final LikeReadDataService _likeReadService;
    private final LikeWriteDataService _likeWriteService;
    private final EntityMemberService _entityMemberService;
    private final EntityMemberWorkflowImportService _entityMemberWorkflowImportService;
    private final ConfigFileService _configFileService;
    private final MailManager _mailManager;
    private final ServerUrlUtil _serverUrlUtil;
    private final RegistrationService _registrationService;
    private final InternalLinkService _internalLinkService;
    private final Supplier<TenantId> _tenantIdSupplier;
    private final JucoPasswordEncoder _passwordEncoder;
    private final PersonTenantService _personTenantService;
    private final UserGroupMembershipsImportPublisher _userGroupMembershipsImportPublisher;
    private final MigrationSettings _migrationSettings;

    @Autowired
    public PersonDataImportServiceImpl(UpdateEventHandler updateEventHandler, JCEventBus jcEventBus, PersonService personService, PersonRoleService personRoleService, Clock clock, ImportResultMailService importResultMailService, PersonDAO personDAO, LanguageDAO languageDAO, PersonWriteDataService personWriteDataService, PersonImportMappingDAO personImportMappingDAO, Settings settings, ProfileReadDataService profileReadDataService, ProfileWriteDataService profileWriteDataService, TransactionHelper transactionHelper, PersonExternalIdPublisher personExternalIdPublisher, MobileLogoutService mobileLogoutService, EntityService entityService, LikeReadDataService likeReadService, LikeWriteDataService likeWriteService, EntityMemberService entityMemberService, EntityMemberWorkflowImportService entityMemberWorkflowImportService, ConfigFileService configFileService, @Qualifier(value="mailManager") MailManager mailManager, ServerUrlUtil serverUrlUtil, RegistrationService registrationService, InternalLinkService internalLinkService, JucoPasswordEncoder passwordEncoder, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> tenantIdSupplier, PersonTenantService personTenantService, UserGroupMembershipsImportPublisher userGroupMembershipsImportPublisher, MigrationSettings migrationSettings) {
        this._personService = personService;
        this._personRoleService = personRoleService;
        this._clock = clock;
        this._importResultMailService = importResultMailService;
        this._personDAO = personDAO;
        this._languageDAO = languageDAO;
        this._personWriteDataService = personWriteDataService;
        this._personImportMappingDAO = personImportMappingDAO;
        this._settings = settings;
        this._profileReadDataService = profileReadDataService;
        this._profileWriteDataService = profileWriteDataService;
        this._transactionHelper = transactionHelper;
        this._personExternalIdPublisher = personExternalIdPublisher;
        this._mobileLogoutService = mobileLogoutService;
        this._updateHandler = updateEventHandler;
        this._eventBus = jcEventBus;
        this._entityService = entityService;
        this._likeReadService = likeReadService;
        this._likeWriteService = likeWriteService;
        this._entityMemberService = entityMemberService;
        this._entityMemberWorkflowImportService = entityMemberWorkflowImportService;
        this._configFileService = configFileService;
        this._mailManager = mailManager;
        this._serverUrlUtil = serverUrlUtil;
        this._registrationService = registrationService;
        this._internalLinkService = internalLinkService;
        this._passwordEncoder = passwordEncoder;
        this._tenantIdSupplier = tenantIdSupplier;
        this._personTenantService = personTenantService;
        this._userGroupMembershipsImportPublisher = userGroupMembershipsImportPublisher;
        this._migrationSettings = migrationSettings;
    }

    @Override
    public ImportStatistics importPerson(String externalId, Map<String, String> staticAttributes, ListMultimap<String, String> dynamicAttributes, ImmutableSet<String> roles, Boolean replaceExistingRoles, Boolean termsAccepted, Boolean sendMailToNewUser, Boolean activateNewUser, Boolean reimportDeletedUser, PersonImportServiceImpl.PersonImportMode importMode, Boolean blockUser, List<PersonSubscriptionData> personSubscriptionData, List<PersonMembershipData> personMembershipData, List<UserGroupId> addedUserGroupMemberships, List<UserGroupId> removedUserGroupMemberships, AuthorizationCheckContext authContext) throws ServiceException {
        ImportStatistics statistics;
        authContext.check(StaticAction.PROFILE_IMPORT);
        PersonImportServiceImpl<GenericPersonImportModel> personImportService = this.createPersonImporter();
        this.initPersonImporter(externalId, staticAttributes, dynamicAttributes, roles, replaceExistingRoles, personImportService, termsAccepted, sendMailToNewUser, activateNewUser, reimportDeletedUser, importMode, blockUser, personSubscriptionData, personMembershipData, addedUserGroupMemberships, removedUserGroupMemberships);
        try {
            statistics = personImportService.importPersons();
        }
        catch (ImportException e) {
            String message = "Import failed for person with externalID: " + externalId;
            throw new ServiceException(message, e);
        }
        if (statistics.getFailedCount() > 0 || statistics.getSkippedCount() > 0) {
            LOG.info("Import " + (statistics.getFailedCount() > 0 ? "failed" : "skipped") + " for person with externalID: " + externalId);
        } else {
            LOG.info("Import successfully " + (statistics.getInsertCount() > 0 ? "inserted" : "updated") + " person with externalID: " + externalId);
        }
        return statistics;
    }

    @Nonnull
    private PersonImportServiceImpl<GenericPersonImportModel> createPersonImporter() {
        return new PersonImportServiceImpl<GenericPersonImportModel>(this._personService, this._updateHandler, this._eventBus, this._clock, this._importResultMailService, this._personDAO, this._languageDAO, this._personWriteDataService, this._personImportMappingDAO, this._settings, this._profileReadDataService, this._profileWriteDataService, this._transactionHelper, this._personExternalIdPublisher, this._mobileLogoutService, this._passwordEncoder, this._tenantIdSupplier, this._personTenantService, new NonLockingImportProcessLockService());
    }

    private void initPersonImporter(String externalId, Map<String, String> staticAttributes, ListMultimap<String, String> dynamicAttributes, ImmutableSet<String> roles, Boolean replaceExistingRoles, PersonImportServiceImpl<GenericPersonImportModel> personImportService, @Nullable Boolean termsAccepted, @Nullable Boolean sendMailToNewUser, @Nullable Boolean activateNewUser, @Nullable Boolean reimportDeletedUser, @Nullable PersonImportServiceImpl.PersonImportMode importMode, @Nullable Boolean blockUser, List<PersonSubscriptionData> personSubscriptionData, List<PersonMembershipData> personMembershipData, List<UserGroupId> addedUserGroupMemberships, List<UserGroupId> removedUserGroupMemberships) {
        personImportService.setImportDataProvider(new GenericPersonImportDataProvider(externalId, staticAttributes, dynamicAttributes, roles, blockUser, addedUserGroupMemberships, removedUserGroupMemberships));
        if (termsAccepted != null) {
            personImportService.setAcceptTermsForNewUser(termsAccepted);
        }
        if (activateNewUser != null) {
            personImportService.setActivateNewUser(activateNewUser);
        }
        if (reimportDeletedUser != null) {
            personImportService.setReimportDeletedUsers(reimportDeletedUser);
        }
        if (importMode != null) {
            personImportService.setImportMode(importMode);
        }
        List<SubscriptionImportPostProcessor<GenericPersonImportModel>> subscriptionsPostProcessors = this.createSubscriptionPostProcessors(personSubscriptionData);
        List<MembershipImportPostProcessor<GenericPersonImportModel>> membershipPostProcessors = this.createMembershipPostProcessors(personMembershipData);
        List<StaticRoleImportPostProcessor<GenericPersonImportModel>> rolePostProcessors = this.createRolePostProcessors((Set<String>)roles, replaceExistingRoles);
        List<NewUserGreetingImportPostProcessor> greetingPostProcessors = this.createGreetingPostProcessors(sendMailToNewUser);
        ImmutableList postProcessors = ImmutableList.builder().addAll(subscriptionsPostProcessors).addAll(membershipPostProcessors).addAll(rolePostProcessors).addAll(greetingPostProcessors).add(new UserGroupMembershipsImportPostProcessor(this._userGroupMembershipsImportPublisher)).build();
        personImportService.setImportPostProcessorList(postProcessors);
    }

    @Nonnull
    private List<NewUserGreetingImportPostProcessor> createGreetingPostProcessors(@Nullable Boolean sendMailToNewUser) {
        if (sendMailToNewUser != null && sendMailToNewUser.booleanValue()) {
            return ImmutableList.of((Object)new NewUserGreetingImportPostProcessor(this._mailManager, this._serverUrlUtil, this._registrationService, this._internalLinkService));
        }
        return ImmutableList.of();
    }

    @Nonnull
    private SubscriptionImportPostProcessor<GenericPersonImportModel> getPostProcessorForType(@Nullable SubscriptionType type) {
        if (SubscriptionType.RECOMMENDED.equals((Object)type)) {
            return new RecommendedSubscriptionImportPostProcessor<GenericPersonImportModel>(this._entityService, this._likeReadService, this._likeWriteService, this._migrationSettings);
        }
        return new PassiveSubscriptionImportPostProcessor<GenericPersonImportModel>(this._entityService, this._likeReadService, this._likeWriteService, this._migrationSettings);
    }

    @Nonnull
    private List<SubscriptionImportPostProcessor<GenericPersonImportModel>> createSubscriptionPostProcessors(List<PersonSubscriptionData> personSubscriptionDataList) {
        return (List)personSubscriptionDataList.stream().map(personSubscriptionData -> {
            SubscriptionType subscriptionType = personSubscriptionData.getSubscriptionType();
            SubscriptionImportPostProcessor<GenericPersonImportModel> postProcessor = this.getPostProcessorForType(subscriptionType);
            postProcessor.setDefaultEntityIds(personSubscriptionData.getDefaultEntityIds());
            postProcessor.setEntityTypesForSubscriptions(personSubscriptionData.getFilterByEntityTypes());
            Optional.ofNullable(personSubscriptionData.getExclusive()).ifPresent(postProcessor::setExclusive);
            return postProcessor;
        }).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private List<MembershipImportPostProcessor<GenericPersonImportModel>> createMembershipPostProcessors(List<PersonMembershipData> personMembershipDataList) {
        return (List)personMembershipDataList.stream().map(personMembershipData -> {
            MembershipImportPostProcessor postProcessor = new MembershipImportPostProcessor(this._entityMemberService, this._entityMemberWorkflowImportService, this._migrationSettings);
            postProcessor.setDefaultEntityIds(personMembershipData.getDefaultEntityIds());
            postProcessor.setOverrideMembershipForEntityTypes(personMembershipData.getReplaceMembershipsForEntityTypes());
            return postProcessor;
        }).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private List<StaticRoleImportPostProcessor<GenericPersonImportModel>> createRolePostProcessors(Set<String> roles, Boolean replaceExistingRole) {
        if (roles.isEmpty() && replaceExistingRole == null) {
            return ImmutableList.of();
        }
        StaticRoleImportPostProcessor<GenericPersonImportModel> staticRoleImportPostProcessor = new StaticRoleImportPostProcessor<GenericPersonImportModel>(this._personRoleService, this._configFileService, this._migrationSettings);
        staticRoleImportPostProcessor.setImportDataProvider(new GenericRoleImportDataProvider());
        if (replaceExistingRole != null) {
            staticRoleImportPostProcessor.setOverrideExisting(replaceExistingRole);
        }
        return ImmutableList.of(staticRoleImportPostProcessor);
    }
}

