/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Strings;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.migration.shared.server.model.UserData;
import de.justsoftware.onx.person.business.RegistrationService;
import de.justsoftware.onx.person.model.DBPerson;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParametersAreNonnullByDefault
public class NewUserGreetingImportPostProcessor
implements ImportPostProcessor<PersonImportModel<?>> {
    private static final Logger LOGGER = PersonImportService.IMPORT_LOG;
    private final MailManager _mailManager;
    private final ServerUrlUtil _serverUrlUtil;
    private final RegistrationService _registrationService;
    private final InternalLinkService _internalLinkService;

    @Autowired
    public NewUserGreetingImportPostProcessor(@Qualifier(value="mailManager") MailManager mailManager, ServerUrlUtil serverUrlUtil, RegistrationService registrationService, InternalLinkService internalLinkService) {
        this._mailManager = mailManager;
        this._serverUrlUtil = serverUrlUtil;
        this._registrationService = registrationService;
        this._internalLinkService = internalLinkService;
    }

    @Override
    public void process(List<? extends PersonImportModel<?>> importedPerson, ImportUpdateEventCollector importUpdateEventCollector) {
        for (PersonImportModel<?> personImportModel : importedPerson) {
            this.processSingleModel(personImportModel);
        }
    }

    private void processSingleModel(PersonImportModel<?> importedPerson) {
        DBPerson person = importedPerson.getPerson();
        if (!importedPerson.isNew()) {
            LOGGER.info("Only send emails to newly created persons. Skipping this person {}", (Object)person.getEmail());
            return;
        }
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setClassForTemplateLoading(this.getClass(), "/etc/");
            Template body = this.createTemplate(cfg, "notification_new_user_body.ftl", person.getLanguageId());
            Template subject = this.createTemplate(cfg, "notification_new_user_subject.ftl", person.getLanguageId());
            HashMap<String, Object> root = new HashMap<String, Object>();
            UserData user = importedPerson.accept(new UserDataFactory(this._registrationService));
            root.put("user", user);
            root.put("url", this._serverUrlUtil.getSystemDomainPrefix());
            StringWriter bodyWriter = new StringWriter();
            body.process(root, (Writer)bodyWriter);
            StringWriter subjectWriter = new StringWriter();
            subject.process(root, (Writer)subjectWriter);
            this._mailManager.sendMail(person, ((Object)subjectWriter).toString(), ((Object)bodyWriter).toString(), MailType.IMPORTED_USER_GREETING);
            LOGGER.info("Successfully sent email to new user {}", (Object)person.getEmail());
        }
        catch (IOException e) {
            LOGGER.error("Error loading template file", (Throwable)e);
        }
        catch (TemplateException e) {
            LOGGER.error("Error processing template", (Throwable)e);
        }
    }

    @Nonnull
    private Template createTemplate(Configuration cfg, String templateName, @Nullable String languageId) throws IOException {
        if (!Strings.isNullOrEmpty((String)languageId)) {
            return cfg.getTemplate(templateName, new Locale(languageId));
        }
        return cfg.getTemplate(templateName);
    }

    private class UserDataFactory
    implements PersonImportModelVisitor<UserData> {
        private final RegistrationService _service;

        protected UserDataFactory(RegistrationService service) {
            this._service = service;
        }

        @Override
        public UserData visitCSVPersonImportModel(CSVPersonImportModel importModel) {
            return this.createUserData(importModel.getPerson(), importModel.getPlainPassword());
        }

        @Override
        public UserData visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
            return this.createUserData(importModel.getPerson(), null);
        }

        @Override
        public UserData visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
            return this.createUserData(importModel.getPerson(), importModel.getPlainPassword());
        }

        @Override
        public UserData visitGenericPersonImportModel(GenericPersonImportModel importModel) {
            return this.createUserData(importModel.getPerson(), importModel.getPlainPassword());
        }

        @Nonnull
        private UserData createUserData(@Nonnull DBPerson person, @Nullable String password) {
            return new UserData(person.getFullName(), person.getFirstName(), person.getLastName(), person.getTitle(), person.getAdditionalTitle(), person.getEmail(), password, NewUserGreetingImportPostProcessor.this._internalLinkService.addHost(this._service.generateActivationLink(person)));
        }
    }
}

