/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class MultiplePersonImportServicesImpl
implements PersonImportService {
    private final ImmutableList<PersonImportService> _importServices;
    private final Clock _clock;
    private final MigrationSettings _migrationSettings;
    private final ImportProcessLockService _importProcessLockService;

    @Autowired
    public MultiplePersonImportServicesImpl(List<PersonImportService> importServices, Clock clock, MigrationSettings migrationSettings, ImportProcessLockService importProcessLockService) {
        this._importProcessLockService = importProcessLockService;
        this._importServices = ImmutableList.copyOf(importServices);
        this._clock = clock;
        this._migrationSettings = migrationSettings;
    }

    @Override
    public ImportStatistics importPersons() throws ImportException {
        return this._importProcessLockService.acquireAndExecute(this::doImport);
    }

    @Override
    public ImportStatistics doImport() {
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        for (PersonImportService importService : this._importServices) {
            ImportStatistics result = importService.doImport();
            statistics = statistics.merge(result);
        }
        return statistics;
    }

    @Override
    public boolean isEnabled() {
        return this._migrationSettings.isImportPersonsEnabled();
    }
}

