/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowImportService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class MembershipImportPostProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    private final EntityMemberService _entityMemberService;
    private final EntityMemberWorkflowImportService _entityMemberWorkflowService;
    private final MigrationSettings _migrationSettings;
    private ImmutableSet<EntityId> _defaultEntityIds = ImmutableSet.of();
    private boolean _useMigrationSettingsDefaultEntityIds = true;
    private ImmutableSet<EntityType> _overrideMembershipForEntityTypes = ImmutableSet.of();
    private MembershipImportDataProvider<? super I> _importDataProvider = importedData -> ImmutableList.of();

    @ParametersAreNonnullByDefault
    @Autowired
    public MembershipImportPostProcessor(EntityMemberService entityMemberReadWriteDataService, EntityMemberWorkflowImportService entityMemberWorkflowImportService, MigrationSettings migrationSettings) {
        this._entityMemberService = entityMemberReadWriteDataService;
        this._entityMemberWorkflowService = entityMemberWorkflowImportService;
        this._migrationSettings = migrationSettings;
    }

    public void setDefaultEntityId(@Nullable Long id) {
        if (id == null) {
            this.setDefaultEntityIds((List<Long>)ImmutableList.of());
        } else {
            this.setDefaultEntityIds((List<Long>)ImmutableList.of((Object)id));
        }
    }

    public void setDefaultEntityIds(List<Long> ids) {
        this._defaultEntityIds = FluentIterable.from(ids).transform(EntityId.FROM_LONG).toSet();
    }

    public void setUseMigrationSettingsDefaultEntityIds(boolean useMigrationSettingsDefaultEntityIds) {
        this._useMigrationSettingsDefaultEntityIds = useMigrationSettingsDefaultEntityIds;
    }

    public void setImportDataProvider(MembershipImportDataProvider<? super I> importDataProvider) {
        this._importDataProvider = importDataProvider;
    }

    public void setOverrideMembershipForEntityTypes(List<String> overrideMembershipForEntityTypes) {
        this._overrideMembershipForEntityTypes = ImmutableSet.copyOf((Collection)Lists.transform(overrideMembershipForEntityTypes, EntityType.FROM_NAME));
    }

    @Override
    public void process(List<? extends I> importedPersons, ImportUpdateEventCollector importUpdateEventCollector) {
        ImmutableSet importedPersonIds = importedPersons.stream().map(PersonImportModel.TO_PERSON_ID).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
        try {
            MemberChangeOptions noNotifications = MemberChangeOptions.builder().disableEmailNotification().setBulk(true).setEntityNewMembershipWorkstreamMessage(false).setUpdateSubscriptions(false).build();
            SetMultimap<EntityId, PersonId> importedMembershipsByEntityId = this.mapImportedMembershipsByEntityId(importedPersons, (ImmutableSet<PersonId>)importedPersonIds);
            ImmutableSet memberRolesOfInterest = ImmutableSet.of((Object)EntityMemberRole.MEMBER, (Object)EntityMemberRole.ADMIN, (Object)EntityMemberRole.CO_ADMIN);
            ImmutableSetMultimap<EntityId, PersonId> membershipFromDB = !this._overrideMembershipForEntityTypes.isEmpty() ? this._entityMemberService.getEntityMembersByEntityTypesAndPersonIdsAndRoles((Set<EntityType>)this._overrideMembershipForEntityTypes, (Set<PersonId>)importedPersonIds, (Set<EntityMemberRole>)memberRolesOfInterest) : this._entityMemberService.getEntityIdsByPersonIdAndMemberRoles((Set<PersonId>)importedPersonIds, (Set<EntityMemberRole>)memberRolesOfInterest).inverse();
            for (EntityId entityId : importedMembershipsByEntityId.keySet()) {
                Set personIds = importedMembershipsByEntityId.get((Object)entityId);
                Sets.SetView personIdsToAdd = Sets.difference((Set)personIds, CollectionUtil.nonNullImmutableSet(membershipFromDB.get((Object)entityId)));
                try {
                    if (personIdsToAdd.isEmpty()) continue;
                    this._entityMemberWorkflowService.addMembers(entityId, (Set<PersonId>)personIdsToAdd, noNotifications, importUpdateEventCollector);
                    PersonImportService.IMPORT_LOG.info("Added memberships of entity {} for persons {}", (Object)entityId, (Object)personIdsToAdd);
                }
                catch (DAOException e) {
                    PersonImportService.IMPORT_LOG.error(String.format("Could not add memberships to entity %1$s for person ids %2$s", entityId, personIdsToAdd), (Throwable)e);
                }
            }
            if (!this._overrideMembershipForEntityTypes.isEmpty()) {
                for (EntityId entityId : membershipFromDB.keySet()) {
                    Sets.SetView toRemoveMembership = Sets.difference((Set)Sets.newHashSet((Iterable)membershipFromDB.get((Object)entityId)), (Set)importedMembershipsByEntityId.get((Object)entityId));
                    if (toRemoveMembership.isEmpty()) continue;
                    this._entityMemberWorkflowService.removeMembers(entityId, (Set<PersonId>)toRemoveMembership, noNotifications, importUpdateEventCollector);
                    PersonImportService.IMPORT_LOG.info("Removed memberships of entity {} for persons {}", (Object)entityId, (Object)toRemoveMembership);
                }
            }
        }
        catch (ImportException e) {
            PersonImportService.IMPORT_LOG.error("Error occured while importing memberships. Membership import aborted for this chunk.", (Throwable)e);
        }
    }

    @Nonnull
    private SetMultimap<EntityId, PersonId> mapImportedMembershipsByEntityId(List<? extends I> importedPersons, ImmutableSet<PersonId> importedPersonIds) throws ImportException {
        HashMultimap importedMembershipsByEntityId = HashMultimap.create();
        Iterable importedMemberships = this._importDataProvider.getAdditionalImportDataFor(importedPersons);
        for (MembershipImportModel memberShip : importedMemberships) {
            importedMembershipsByEntityId.putAll(memberShip.getMembershipsByEntityId());
        }
        this.getConfiguredDefaultEntities().forEach(arg_0 -> MembershipImportPostProcessor.lambda$mapImportedMembershipsByEntityId$1((SetMultimap)importedMembershipsByEntityId, importedPersonIds, arg_0));
        return importedMembershipsByEntityId;
    }

    private Stream<EntityId> getConfiguredDefaultEntities() {
        if (!this._useMigrationSettingsDefaultEntityIds) {
            return this._defaultEntityIds.stream();
        }
        return Stream.concat(this._defaultEntityIds.stream(), this._migrationSettings.getImportMembershipDefaultEntityIds().stream());
    }

    private static /* synthetic */ void lambda$mapImportedMembershipsByEntityId$1(SetMultimap importedMembershipsByEntityId, ImmutableSet importedPersonIds, EntityId entityId) {
        importedMembershipsByEntityId.putAll((Object)entityId, (Iterable)importedPersonIds);
    }

    public static interface MembershipImportDataProvider<J extends PersonImportModel<?>>
    extends ImportProcessor.ImportDataProvider<J, MembershipImportModel> {
    }
}

