/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.integration.persistence.ibatis.PersonEntityMappingIbatisModel;
import de.justsoftware.onx.migration.shared.server.model.ImportModel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MembershipImportModel
implements ImportModel {
    private final ImmutableSet<EntityId> _entityIds;
    private final ImmutableSet<PersonId> _personIds;

    public MembershipImportModel(ImmutableSet<EntityId> entityIds, ImmutableSet<PersonId> personIds) {
        this._entityIds = entityIds;
        this._personIds = personIds;
    }

    @Nonnull
    public ImmutableSet<EntityId> getEntityIds() {
        return this._entityIds;
    }

    @Nonnull
    public ImmutableSet<PersonId> getPersonIds() {
        return this._personIds;
    }

    @CheckForNull
    public static MembershipImportModel fromPersonEntityRelation(PersonEntityMappingIbatisModel personEntityRelation, Map<String, PersonId> idMapping) {
        PersonId personId = idMapping.get(personEntityRelation.getExternalId());
        EntityId entityId = personEntityRelation.getEntityId();
        return personId == null ? null : new MembershipImportModel((ImmutableSet<EntityId>)ImmutableSet.of((Object)entityId), (ImmutableSet<PersonId>)ImmutableSet.of((Object)personId));
    }

    @Nonnull
    public SetMultimap<EntityId, PersonId> getMembershipsByEntityId() {
        ImmutableSetMultimap.Builder memberships = ImmutableSetMultimap.builder();
        for (EntityId entityId : this._entityIds) {
            memberships.putAll((Object)entityId, this._personIds);
        }
        return memberships.build();
    }

    @Nonnull
    public SetMultimap<PersonId, EntityId> getMembershipsByPersonId() {
        ImmutableSetMultimap.Builder memberships = ImmutableSetMultimap.builder();
        for (PersonId personId : this._personIds) {
            memberships.putAll((Object)personId, this._entityIds);
        }
        return memberships.build();
    }
}

