/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.MembershipImportService;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPExternalIdMapper;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContextIterator;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.directory.Attributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;

public class LDAPSearchEntityRoleMembershipImportDataProvider
implements MembershipImportService.MembershipImportDataProvider {
    private InternalLDAPSearchContext _membershipSearchContext;
    private InternalLDAPSearchContext _personSearchContext;
    private String _entityIdDNSuffix;
    @Autowired
    private PersonImportMappingDAO _personImportMappingDAO;
    private LDAPValueExtractor<EntityId> _entityIdExtractor;
    private LDAPValueExtractor<String> _memberValueExtractor;
    @Autowired
    private DomainResolver _domainResolver;
    private String _noMemberDN = "cn=no-member";

    @Required
    public void setMembershipSearchContext(@Nonnull LDAPSearchContext searchContext) {
        this._membershipSearchContext = InternalLDAPSearchContext.createFrom(searchContext);
    }

    @Required
    public void setPersonSearchContext(@Nonnull LDAPSearchContext personSearchContext) {
        this._personSearchContext = InternalLDAPSearchContext.createFrom(personSearchContext);
    }

    @Required
    public void setMemberValueExtractor(@Nonnull LDAPValueExtractor<String> memberValueExtractor) {
        this._memberValueExtractor = memberValueExtractor;
    }

    @Required
    public void setEntityIdDNSuffix(@Nonnull String entityIdDNSuffix) {
        this._entityIdDNSuffix = entityIdDNSuffix;
    }

    @Required
    public void setEntityIdExtractor(@Nonnull LDAPValueExtractor<EntityId> entityIdExtractor) {
        this._entityIdExtractor = entityIdExtractor;
    }

    public void setPersonImportDAO(@Nonnull PersonImportMappingDAO personImportMappingDAO) {
        this._personImportMappingDAO = personImportMappingDAO;
    }

    public void setNoMemberDN(@Nonnull String noMemberDN) {
        this._noMemberDN = noMemberDN;
    }

    @Override
    public Iterable<List<MembershipImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        InternalLDAPSearchContext searchContextWithFilter = this._membershipSearchContext.withFilter(this.createEntityRoleFilter(this._membershipSearchContext.getFilter()));
        PersonImportService.IMPORT_LOG.info("Loading import models: {}", (Object)this.getClass().getName());
        Iterator<List<MembershipImportModel>> importModelsIterator = LDAPSearchContextIterator.getImportModelsFromContext(searchContextWithFilter, new MembershipAttributeMapper());
        ImmutableList batches = ImmutableList.copyOf(importModelsIterator);
        Iterable models = Iterables.concat((Iterable)batches);
        statistics.incProcessed(Iterables.size((Iterable)models));
        return batches;
    }

    @Nonnull
    private Filter createEntityRoleFilter(@Nullable Filter configuredFilter) {
        WhitespaceWildcardsFilter cnRoleFilter = new WhitespaceWildcardsFilter("cn", this._entityIdDNSuffix);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)cnRoleFilter);
        if (configuredFilter != null) {
            andFilter.and(configuredFilter);
        }
        return andFilter;
    }

    private class MembershipAttributeMapper
    extends AbstractContextMapper<MembershipImportModel> {
        private MembershipAttributeMapper() {
        }

        public MembershipImportModel doMapFromContext(DirContextOperations contextOperations) {
            Attributes attrs = contextOperations.getAttributes();
            ImmutableSet<EntityId> entityIds = LDAPSearchEntityRoleMembershipImportDataProvider.this._entityIdExtractor.getValues(attrs);
            ImmutableSet<String> memberIds = LDAPSearchEntityRoleMembershipImportDataProvider.this._memberValueExtractor.getValues(attrs);
            ImmutableSet.Builder memberAsPersonIds = ImmutableSet.builder();
            for (String memberDN : memberIds) {
                if (memberDN.equals(LDAPSearchEntityRoleMembershipImportDataProvider.this._noMemberDN)) continue;
                try {
                    LDAPPersonIdentifier identifier = (LDAPPersonIdentifier)LDAPSearchEntityRoleMembershipImportDataProvider.this._personSearchContext.getLdapTemplate().lookup(memberDN, (ContextMapper)new LDAPExternalIdMapper(LDAPSearchEntityRoleMembershipImportDataProvider.this._personSearchContext.getExternalIdField(), LDAPSearchEntityRoleMembershipImportDataProvider.this._domainResolver));
                    if (identifier == null) continue;
                    String externalId = identifier.toExternalIdString();
                    PersonId internalId = LDAPSearchEntityRoleMembershipImportDataProvider.this._personImportMappingDAO.getInternalId(externalId);
                    if (internalId != null) {
                        memberAsPersonIds.add((Object)internalId);
                        continue;
                    }
                    PersonImportService.IMPORT_LOG.warn("Could not find internal person with external id " + externalId);
                }
                catch (NameNotFoundException e) {
                    PersonImportService.IMPORT_LOG.warn("Could not find member with DN " + memberDN + ". Skipping this DN.");
                }
            }
            return new MembershipImportModel(entityIds, (ImmutableSet<PersonId>)memberAsPersonIds.build());
        }
    }
}

