/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.JuCoPagedResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.control.PagedResultsCookie;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.ldap.filter.Filter;

public final class LDAPSearchContextIterator<T>
extends AbstractIterator<List<T>> {
    private final SingleContextSource _singleContextSource;
    private JuCoPagedResult<T> _previousResult;
    private final LdapTemplate _ldapTemplate;
    private final InternalLDAPSearchContext _searchContext;
    private final String _baseDN;
    private final AbstractContextMapper<T> _attributeMapper;

    private LDAPSearchContextIterator(@Nonnull String baseDN, @Nonnull InternalLDAPSearchContext searchContext, @Nonnull AbstractContextMapper<T> attributeMapper) {
        this._searchContext = searchContext;
        this._baseDN = baseDN;
        this._attributeMapper = attributeMapper;
        this._singleContextSource = new SingleContextSource(searchContext.getLdapTemplate().getContextSource().getReadOnlyContext());
        this._ldapTemplate = new LdapTemplate((ContextSource)this._singleContextSource);
        this._ldapTemplate.setIgnorePartialResultException(true);
        if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
            PersonImportService.IMPORT_LOG.info("* Starting ldap search with BaseDN {} and filter {}", (Object)baseDN, (Object)searchContext.getFilter());
        }
    }

    protected List<T> computeNext() {
        if (this._previousResult == null || this._previousResult.getCookie().getCookie() != null) {
            try {
                JuCoPagedResult<T> pagedResult = this.searchNextPage(this._baseDN, this._searchContext.getFilter(), this._searchContext.getSearchControl(), this._ldapTemplate, this._searchContext.getPageSize());
                List<T> importedResultList = pagedResult.getResultList();
                this._previousResult = pagedResult;
                return importedResultList;
            }
            catch (NameNotFoundException e) {
                PersonImportService.IMPORT_LOG.error("Could not find BaseDN " + this._baseDN + ". Skipping this DN.", (Throwable)e);
            }
            catch (NamingException e) {
                PersonImportService.IMPORT_LOG.error("Error while retrieving next batch for  " + this._baseDN + " and filter " + this._searchContext.getFilter() + ". Abort processing for this DN.", (Throwable)e);
                this.closeContext();
                throw e;
            }
        }
        if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
            PersonImportService.IMPORT_LOG.info("* No more results with baseDN {} and filter {}", (Object)this._baseDN, (Object)this._searchContext.getFilter());
        }
        this.closeContext();
        return (List)this.endOfData();
    }

    private void closeContext() {
        if (this._singleContextSource != null) {
            this._singleContextSource.destroy();
        }
    }

    @Nonnull
    private JuCoPagedResult<T> searchNextPage(@Nonnull String baseDN, @Nullable Filter filter, @Nonnull SearchControls searchControls, @Nonnull LdapTemplate ldapTemplate, int pageSize) {
        PagedResultsCookie cookie = this._previousResult != null ? this._previousResult.getCookie() : null;
        PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(pageSize, cookie);
        String filterString = filter != null ? filter.encode() : null;
        ImmutableList importedResultList = FluentIterable.from((Iterable)ldapTemplate.search(baseDN, filterString, searchControls, this._attributeMapper, (DirContextProcessor)processor)).filter(Predicates.notNull()).toList();
        return new JuCoPagedResult(importedResultList, processor.getCookie());
    }

    @Nonnull
    public static <T> Iterator<List<T>> getImportModelsFromContext(@Nonnull InternalLDAPSearchContext searchContext, @Nonnull AbstractContextMapper<T> attributeMapper) throws ImportException {
        PersonImportService.IMPORT_LOG.info("Number of baseDN: " + searchContext.getBaseDNs().size());
        PersonImportService.IMPORT_LOG.info("Search scope: " + searchContext.getSearchControl().getSearchScope());
        PersonImportService.IMPORT_LOG.info("Paging: {} (page size {}) ", (Object)searchContext.isPagingEnabled(), (Object)searchContext.getPageSize());
        PersonImportService.IMPORT_LOG.info("Filter: {}", (Object)searchContext.getFilter());
        ArrayList sources = Lists.newArrayList();
        for (String baseDN : searchContext.getBaseDNs()) {
            try {
                if (searchContext.isPagingEnabled()) {
                    sources.add(new LDAPSearchContextIterator<T>(baseDN, searchContext, attributeMapper));
                    continue;
                }
                sources.add(new LDAPSearchContextNoPagingIterator<T>(baseDN, searchContext, attributeMapper));
            }
            catch (RuntimeException ex) {
                throw new ImportException("Import of baseDn " + baseDN + " failed", ex);
            }
        }
        return Iterators.concat(sources.iterator());
    }

    private static final class LDAPSearchContextNoPagingIterator<T>
    extends AbstractIterator<List<T>> {
        private final InternalLDAPSearchContext _searchContext;
        private final String _baseDN;
        private final AbstractContextMapper<T> _attributeMapper;
        private boolean _executed = false;

        private LDAPSearchContextNoPagingIterator(@Nonnull String baseDN, @Nonnull InternalLDAPSearchContext searchContext, @Nonnull AbstractContextMapper<T> attributeMapper) {
            this._searchContext = searchContext;
            this._baseDN = baseDN;
            this._attributeMapper = attributeMapper;
            if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
                PersonImportService.IMPORT_LOG.info("* Starting unpaged ldap search with BaseDN {} and filter {}", (Object)baseDN, (Object)searchContext.getFilter());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<T> computeNext() {
            if (!this._executed) {
                try {
                    List importedResultList;
                    String filterString = null;
                    Filter filter = this._searchContext.getFilter();
                    if (filter != null) {
                        filterString = filter.encode();
                    }
                    List list = importedResultList = this._searchContext.getLdapTemplate().search(this._baseDN, filterString, this._searchContext.getSearchControl().getSearchScope(), this._attributeMapper);
                    return list;
                }
                catch (NameNotFoundException e) {
                    PersonImportService.IMPORT_LOG.error("Could not find BaseDN " + this._baseDN + ". Skipping this DN.", (Throwable)e);
                }
                finally {
                    this._executed = true;
                }
            }
            return (List)this.endOfData();
        }
    }
}

