/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.business.impl.StaticRoleImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class LDAPRoleImportDataProvider
implements StaticRoleImportPostProcessor.StaticRoleImportDataProvider<LDAPPersonImportModel> {
    private LDAPValueExtractor<String> _valueExtractor;

    @Required
    public void setLdapValueExtractor(@Nonnull LDAPValueExtractor<String> valueExtractor) {
        this._valueExtractor = valueExtractor;
    }

    @Override
    public Iterable<StaticRoleImportPostProcessor.StaticRoleImportModel> getAdditionalImportDataFor(List<? extends LDAPPersonImportModel> importedPersons) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LDAPPersonImportModel lDAPPersonImportModel : importedPersons) {
            result.add((Object)this.getImportedRoleNames(lDAPPersonImportModel));
        }
        return result.build();
    }

    @Nonnull
    private StaticRoleImportPostProcessor.StaticRoleImportModel getImportedRoleNames(@Nonnull LDAPPersonImportModel importedPerson) {
        ImmutableSet<String> roleNames = this._valueExtractor.getValues(importedPerson.getAttributes());
        return new StaticRoleImportPostProcessor.StaticRoleImportModel((ImmutableSet<PersonId>)ImmutableSet.of((Object)importedPerson.getPerson().getId()), roleNames);
    }
}

