/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.justsoftware.onx.migration.business.FieldMapping;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPExternalIdUtil;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContextIterator;
import de.justsoftware.onx.migration.business.impl.MappingBasedPersonImportDataProvider;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;

@ParametersAreNonnullByDefault
public class LDAPPersonImportDataProvider
extends MappingBasedPersonImportDataProvider<LDAPPersonImportModel> {
    private List<LDAPSearchContext> _ldapSearchContextList;
    @Autowired
    private DomainResolver _domainResolver;

    @Required
    public void setLdapSearchContextList(List<LDAPSearchContext> ldapSearchContextList) {
        this._ldapSearchContextList = ldapSearchContextList;
    }

    @Override
    public Iterable<List<LDAPPersonImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        ArrayList sources = Lists.newArrayList();
        for (LDAPSearchContext searchContext : this._ldapSearchContextList) {
            PersonImportService.IMPORT_LOG.info("Loading import models: {}", (Object)this.getClass().getName());
            sources.add(LDAPSearchContextIterator.getImportModelsFromContext(InternalLDAPSearchContext.createFrom(searchContext), new PersonAttributesMapper(searchContext.getExternalIdField(), statistics)));
        }
        return () -> Iterators.concat(sources.iterator());
    }

    @ParametersAreNonnullByDefault
    private class PersonAttributesMapper
    extends AbstractContextMapper<LDAPPersonImportModel> {
        private final ExternalIdField _externalIdField;
        private final ImportStatistics _statistics;

        PersonAttributesMapper(ExternalIdField externalIdField, ImportStatistics statistics) {
            this._externalIdField = externalIdField;
            this._statistics = statistics;
        }

        protected LDAPPersonImportModel doMapFromContext(DirContextOperations contextOperations) {
            try {
                FieldMapping fieldMapping = LDAPPersonImportDataProvider.this.getFieldMapping();
                this._statistics.incProcessed(1);
                String externalId = LDAPExternalIdUtil.getExternalIdAsString(contextOperations, this._externalIdField);
                if (externalId == null) {
                    PersonImportService.IMPORT_LOG.error("Failed to create import model for entry with dn " + contextOperations.getDn().toString() + ". No external id found for field " + this._externalIdField);
                    this._statistics.incSkipped(ImportStatistics.ImportErrorType.MISSING_EXTERNAL_ID, contextOperations.getDn().toString());
                    return null;
                }
                LDAPPersonImportModel result = new LDAPPersonImportModel(new DBPerson(), this._externalIdField.getFieldName(), externalId, contextOperations.getAttributes(), contextOperations.getDn(), LDAPPersonImportDataProvider.this._domainResolver.getDomain(contextOperations.getDn()));
                for (String attributeName : fieldMapping.getSourceAttributeNames()) {
                    try {
                        Object[] values = contextOperations.getObjectAttributes(attributeName);
                        for (String juCoFieldName : fieldMapping.getJuCoField(attributeName)) {
                            result.getImportedValues().putAll((Object)juCoFieldName, (Iterable)(values != null ? ImmutableList.copyOf((Object[])values) : ImmutableList.of()));
                            result.addFieldParameters(juCoFieldName, fieldMapping.getAttributeParameters(attributeName));
                        }
                    }
                    catch (RuntimeException e) {
                        PersonImportService.IMPORT_LOG.warn("Could not get attribute with name " + attributeName + ". Skipping this attribute.", (Throwable)e);
                    }
                }
                PersonImportService.IMPORT_LOG.info("Retrieved person from LDAP with external id " + (String)result.getExternalId());
                return result;
            }
            catch (NamingException e) {
                this._statistics.incFailed(ImportStatistics.ImportErrorType.EXCEPTION, contextOperations.getDn().toString());
                PersonImportService.IMPORT_LOG.error("Failed to create import model for entry with dn " + contextOperations.getDn().toString(), (Throwable)e);
                return null;
            }
            catch (ImportException e1) {
                this._statistics.incFailed(ImportStatistics.ImportErrorType.EXCEPTION, "Failed to load field mapping.");
                PersonImportService.IMPORT_LOG.error("Failed to load field mapping.", (Throwable)e1);
                return null;
            }
        }
    }
}

