/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.IdMapper;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.EnumerationUtils;
import org.springframework.beans.factory.annotation.Required;

public class LDAPPathValueExtractor<T>
implements LDAPValueExtractor<T> {
    private final AttributeValueToIdMapper _attributeValueToIdMapper = new AttributeValueToIdMapper();
    private String _attributeFieldName;
    private IdMapper<T> _idMapper;
    private ImmutableSet<String> _prefixes;

    @Required
    public void setAttributeFieldName(@Nonnull String ldapFieldName) {
        this._attributeFieldName = ldapFieldName;
    }

    @Override
    public String getAttributeFieldName() {
        return this._attributeFieldName;
    }

    @Required
    public void setIdMapper(@Nonnull IdMapper<T> idMapper) {
        this._idMapper = idMapper;
    }

    public void setPrefixes(@Nonnull List<String> prefixes) {
        this._prefixes = ImmutableSet.copyOf(prefixes);
    }

    @Override
    public ImmutableSet<T> getValues(Attributes attributes) {
        return FluentIterable.from(this.getAttributeList(attributes)).filter(Object.class).transformAndConcat((Function)this._attributeValueToIdMapper).filter(Predicates.notNull()).toSet();
    }

    @Nonnull
    private List<?> getAttributeList(@Nonnull Attributes attributes) {
        Attribute attribute = attributes.get(this._attributeFieldName);
        try {
            if (attribute != null) {
                return EnumerationUtils.toList(attribute.getAll());
            }
            PersonImportService.IMPORT_LOG.warn("Attribute {} does not exist.", (Object)this._attributeFieldName);
        }
        catch (NamingException e) {
            PersonImportService.IMPORT_LOG.error("Could not access attribute " + this._attributeFieldName, (Throwable)e);
        }
        return ImmutableList.of();
    }

    @Nonnull
    private ImmutableSet<T> getIdsForAttributeValue(@Nullable String attributeValue) {
        return !Strings.isNullOrEmpty((String)attributeValue) ? this._idMapper.getIdsByExternalKeys(this.getAttributeValuesByPrefix(attributeValue)) : ImmutableSet.of();
    }

    @Nonnull
    private String getAttributeValuesByPrefix(@Nonnull String attributeValue) {
        if (this._prefixes == null || this._prefixes.size() == 0) {
            return attributeValue;
        }
        StringBuilder builder = new StringBuilder();
        Iterator valuesWithPrefixesIt = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)attributeValue).iterator();
        while (valuesWithPrefixesIt.hasNext()) {
            Iterator splittedValueWithPrefixIt = Splitter.on((String)"=").trimResults().omitEmptyStrings().split((CharSequence)valuesWithPrefixesIt.next()).iterator();
            if (!splittedValueWithPrefixIt.hasNext()) continue;
            String prefix = (String)splittedValueWithPrefixIt.next();
            if (!this._prefixes.stream().anyMatch(prefix::equalsIgnoreCase) || !splittedValueWithPrefixIt.hasNext()) continue;
            builder.insert(0, (String)splittedValueWithPrefixIt.next());
            builder.insert(0, "/");
        }
        return builder.toString();
    }

    private final class AttributeValueToIdMapper
    extends NullPermeableFunction<Object, ImmutableSet<T>> {
        private AttributeValueToIdMapper() {
        }

        @Override
        protected ImmutableSet<T> applySafe(Object input) {
            return LDAPPathValueExtractor.this.getIdsForAttributeValue(input.toString());
        }
    }
}

