/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.AbstractIterator;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.support.LdapUtils;

@ParametersAreNonnullByDefault
public class LDAPExternalIdUtil {
    @CheckForNull
    public static String getExternalIdAsString(@Nullable DirContextOperations dirContextOperations, ExternalIdField externalIdField) {
        if (dirContextOperations == null) {
            return null;
        }
        Object objectId = dirContextOperations.getObjectAttribute(externalIdField.getFieldName());
        return LDAPExternalIdUtil.getObjectIdAsString(objectId, externalIdField.isGuid());
    }

    @CheckForNull
    public static String getExternalIdAsString(@Nullable Attributes attributes, ExternalIdField externalIdField) {
        if (attributes == null) {
            return null;
        }
        Object objectId = LDAPExternalIdUtil.getObjectAttribute(externalIdField.getFieldName(), attributes);
        return LDAPExternalIdUtil.getObjectIdAsString(objectId, externalIdField.isGuid());
    }

    @CheckForNull
    private static String getObjectIdAsString(@Nullable Object objectId, boolean isGuid) {
        if (objectId == null) {
            return null;
        }
        if (objectId instanceof byte[]) {
            return isGuid ? GUIDConverter.INSTANCE.convert((byte[])objectId) : new String((byte[])objectId, Charsets.UTF_8);
        }
        return objectId.toString();
    }

    @CheckForNull
    private static Object getObjectAttribute(String name, Attributes attributes) {
        try {
            Attribute oneAttr = attributes.get(name);
            if (oneAttr == null || oneAttr.size() == 0) {
                return null;
            }
            return oneAttr.get();
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException((NamingException)e);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class GUIDIterator
    extends AbstractIterator<String> {
        private static final ValueConverter[] BYTE_SEQUENCE = new ValueConverter[]{new ToHexString(3), new ToHexString(2), new ToHexString(1), new ToHexString(0), new ToDashString(), new ToHexString(5), new ToHexString(4), new ToDashString(), new ToHexString(7), new ToHexString(6), new ToDashString(), new ToHexString(8), new ToHexString(9), new ToDashString(), new ToHexString(10), new ToHexString(11), new ToHexString(12), new ToHexString(13), new ToHexString(14), new ToHexString(15)};
        private final byte[] _guid;
        private int _position = 0;

        private GUIDIterator(byte[] guid) {
            if (guid.length != 16) {
                throw new IllegalArgumentException("guid must be 16 bytes!");
            }
            this._guid = guid;
        }

        protected String computeNext() {
            if (this._position >= BYTE_SEQUENCE.length) {
                return (String)this.endOfData();
            }
            String result = BYTE_SEQUENCE[this._position].convert(this._guid);
            ++this._position;
            return result;
        }
    }

    private static class ToDashString
    implements ValueConverter {
        private ToDashString() {
        }

        @Override
        public String convert(byte[] values) {
            return "-";
        }
    }

    private static final class ToHexString
    implements ValueConverter {
        private final int _position;

        private ToHexString(int position) {
            this._position = position;
        }

        @Override
        public String convert(byte[] values) {
            if (this._position < 0 || this._position >= values.length) {
                throw new IndexOutOfBoundsException("Cannot access values of lenght " + values.length + " at position " + this._position);
            }
            return this.getMaskedHexString(values[this._position]);
        }

        @Nonnull
        private String getMaskedHexString(byte objectGUID) {
            int maskedValue = objectGUID & 0xFF;
            return this.addLeadingZero(maskedValue);
        }

        @Nonnull
        private String addLeadingZero(int k) {
            return k <= 15 ? "0" + Integer.toHexString(k) : Integer.toHexString(k);
        }
    }

    private static enum GUIDConverter implements ValueConverter
    {
        INSTANCE;


        @Override
        public String convert(byte[] objectGUID) {
            try {
                GUIDIterator iterator = new GUIDIterator(objectGUID);
                StringBuilder result = new StringBuilder();
                while (iterator.hasNext()) {
                    result.append((String)iterator.next());
                }
                return result.toString();
            }
            catch (IllegalArgumentException e) {
                PersonImportService.IMPORT_LOG.error("objectGUID is not a valid id", (Throwable)e);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                PersonImportService.IMPORT_LOG.error("Error occured while converting objectGUID", (Throwable)e);
                return null;
            }
        }
    }

    private static interface ValueConverter {
        @CheckForNull
        public String convert(byte[] var1);
    }
}

