/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.EntityImportInformationService;
import de.justsoftware.onx.migration.business.EntityImportService;
import de.justsoftware.onx.migration.business.FieldMapping;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.impl.AbstractEntityImportServiceImpl;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPExternalIdUtil;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContextIterator;
import de.justsoftware.onx.migration.business.impl.PropertiesBasedFieldMapping;
import de.justsoftware.onx.migration.business.mapper.EntityFieldsMapper;
import de.justsoftware.onx.migration.business.mapper.commands.SetCommand;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import de.justsoftware.onx.migration.shared.server.model.EntityImportBean;
import de.justsoftware.onx.migration.shared.server.model.LDAPEntityImportModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;

@ParametersAreNonnullByDefault
public class LDAPEntityImportServiceImpl
extends AbstractEntityImportServiceImpl<String, LDAPEntityImportModel<String>>
implements EntityImportInformationService {
    private List<LDAPSearchContext> _ldapSearchContextList;
    private FieldMapping _fieldMapping;
    @Autowired
    private EntityImportDAO<String> _entityImportDAO;

    @Autowired
    public LDAPEntityImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, ImportProcessLockService importProcessLockService, @Qualifier(value="importTenantIdSupplier") com.google.common.base.Supplier<TenantId> importTenantIdSupplier) {
        super(personService, updateEventHandler, eventBus, clock, importResultMailService, importProcessLockService, (Supplier<TenantId>)importTenantIdSupplier);
    }

    @Required
    public void setLdapSearchContextList(List<LDAPSearchContext> ldapSearchContextList) {
        this._ldapSearchContextList = ldapSearchContextList;
    }

    public void setFieldsMappingFile(String fieldsMappingFile) throws ImportException {
        try {
            this._fieldMapping = new PropertiesBasedFieldMapping(fieldsMappingFile);
        }
        catch (IOException e) {
            IMPORT_LOG.error("Could not open field mapping  file " + fieldsMappingFile, (Throwable)e);
            throw new ImportException("Could not open field mapping  file " + fieldsMappingFile, e);
        }
    }

    @Override
    @Nonnull
    protected Iterable<List<LDAPEntityImportModel<String>>> getImportModels(final ImportStatistics statistics) throws ImportException {
        return new Iterable<List<LDAPEntityImportModel<String>>>(){

            @Override
            public Iterator<List<LDAPEntityImportModel<String>>> iterator() {
                ArrayList sources = Lists.newArrayList();
                for (LDAPSearchContext searchContext : LDAPEntityImportServiceImpl.this._ldapSearchContextList) {
                    try {
                        EntityImportService.IMPORT_LOG.info("Loading import models: {}", (Object)this.getClass().getName());
                        sources.add(LDAPSearchContextIterator.getImportModelsFromContext(InternalLDAPSearchContext.createFrom(searchContext), new EntityAttributesMapper(searchContext.getExternalIdField())));
                    }
                    catch (ImportException e) {
                        EntityImportService.IMPORT_LOG.error("Error occured while retrieving entities from import source.", (Throwable)e);
                        statistics.incFailedImports();
                    }
                    statistics.incProcessed(sources.size());
                }
                return Iterators.concat(sources.iterator());
            }
        };
    }

    @Override
    protected EntityImportDAO<String> getEntityImportDAO() {
        return this._entityImportDAO;
    }

    @Override
    public Set<EntityId> findEntitiesInImportSource(Set<EntityId> entityIds) throws ImportException {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (LDAPSearchContext searchContext : this._ldapSearchContextList) {
            IMPORT_LOG.info("Loading import models: {}", (Object)this.getClass().getName());
            Iterator<List<String>> iterator = LDAPSearchContextIterator.getImportModelsFromContext(InternalLDAPSearchContext.createFrom(searchContext), new EntityExternalIdMapper(searchContext.getExternalIdField()));
            while (iterator.hasNext()) {
                Map<String, EntityId> internalIds = this._entityImportDAO.getInternalIds((Collection<String>)iterator.next());
                resultBuilder.addAll(internalIds.values());
            }
        }
        return resultBuilder.build();
    }

    @Override
    public Set<EntityType> getImportedEntityTypes() {
        return ImmutableSet.of((Object)this._type);
    }

    private static class EntityExternalIdMapper
    extends AbstractContextMapper<String> {
        private final ExternalIdField _entityIdField;

        public EntityExternalIdMapper(ExternalIdField entityIdField) {
            this._entityIdField = entityIdField;
        }

        protected String doMapFromContext(DirContextOperations contextOperations) {
            return LDAPExternalIdUtil.getExternalIdAsString(contextOperations, this._entityIdField);
        }
    }

    @ParametersAreNonnullByDefault
    private class EntityAttributesMapper
    extends AbstractContextMapper<LDAPEntityImportModel<String>> {
        private final ExternalIdField _entityIdField;

        public EntityAttributesMapper(ExternalIdField entityIdField) {
            this._entityIdField = entityIdField;
        }

        protected LDAPEntityImportModel<String> doMapFromContext(DirContextOperations contextOperations) {
            Attributes attrs = contextOperations.getAttributes();
            LDAPEntityImportModel<String> result = new LDAPEntityImportModel<String>(attrs);
            EntityImportBean<String> entity = result.getEntity();
            String externalId = LDAPExternalIdUtil.getExternalIdAsString(attrs, this._entityIdField);
            entity.setExternalId(externalId);
            EntityFieldsMapper mapper = new EntityFieldsMapper();
            try {
                NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
                while (enumeration.hasMore()) {
                    Attribute attribute = enumeration.next();
                    String attributeName = attribute.getID();
                    for (String juCoFieldName : LDAPEntityImportServiceImpl.this._fieldMapping.getJuCoField(attributeName)) {
                        SetCommand<LDAPEntityImportModel<LDAPEntityImportModel<String>>> command = mapper.getCommand(juCoFieldName);
                        if (command == null) continue;
                        NamingEnumeration<?> attValues = attribute.getAll();
                        ImmutableList.Builder valuesBuilder = ImmutableList.builder();
                        while (attValues.hasMoreElements()) {
                            valuesBuilder.add(attValues.next());
                        }
                        ImmutableList values = valuesBuilder.build();
                        if (EntityImportService.IMPORT_LOG.isDebugEnabled()) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("Setting ").append(attributeName).append(" with values: ").append(values);
                            sb.append(" of entity ").append((String)entity.getExternalId());
                            EntityImportService.IMPORT_LOG.debug(sb.toString());
                        }
                        command.set(result, (List<Object>)values, new SetCommand.ParameterAccessor(){

                            @Override
                            public String getParameter(String parameterName) {
                                return null;
                            }

                            @Override
                            public boolean synchronize() {
                                return false;
                            }
                        });
                    }
                }
            }
            catch (NamingException e) {
                EntityImportService.IMPORT_LOG.error("Could not get attribute. Skipping this entry!");
            }
            EntityImportService.IMPORT_LOG.info("Retrieved entity from LDAP with name " + entity.getName());
            return result;
        }
    }
}

