/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.business.impl.SubscriptionImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.SubscriptionImportModel;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class LDAPAttributeSubscriptionImportDataProvider
implements SubscriptionImportPostProcessor.SubscriptionImportDataProvider<LDAPPersonImportModel> {
    private LDAPValueExtractor<EntityId> _valueExtractor;

    @Required
    public void setLdapValueExtractor(@Nonnull LDAPValueExtractor<EntityId> valueExtractor) {
        this._valueExtractor = valueExtractor;
    }

    @Override
    public Iterable<SubscriptionImportModel> getAdditionalImportDataFor(List<? extends LDAPPersonImportModel> importedPersons) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LDAPPersonImportModel lDAPPersonImportModel : importedPersons) {
            result.add((Object)this.getImportedEntityIds(lDAPPersonImportModel));
        }
        return result.build();
    }

    @Nonnull
    private SubscriptionImportModel getImportedEntityIds(@Nonnull LDAPPersonImportModel importedPerson) {
        ImmutableSet<EntityId> entities = this._valueExtractor.getValues(importedPerson.getAttributes());
        return new SubscriptionImportModel((Set<EntityId>)entities, (Set<PersonId>)ImmutableSet.of((Object)importedPerson.getPerson().getId()));
    }
}

