/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.impl.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class LDAPAttributeMembershipImportDataProvider
implements MembershipImportPostProcessor.MembershipImportDataProvider<LDAPPersonImportModel> {
    private LDAPValueExtractor<EntityId> _valueExtractor;

    @Required
    public void setLdapValueExtractor(@Nonnull LDAPValueExtractor<EntityId> valueExtractor) {
        this._valueExtractor = valueExtractor;
    }

    @Override
    public Iterable<MembershipImportModel> getAdditionalImportDataFor(List<? extends LDAPPersonImportModel> importedPersons) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LDAPPersonImportModel lDAPPersonImportModel : importedPersons) {
            result.add((Object)this.getImportedEntityIds(lDAPPersonImportModel));
        }
        return result.build();
    }

    @Nonnull
    private MembershipImportModel getImportedEntityIds(@Nonnull LDAPPersonImportModel importedPerson) {
        ImmutableSet<EntityId> entities = this._valueExtractor.getValues(importedPerson.getAttributes());
        return new MembershipImportModel(entities, (ImmutableSet<PersonId>)ImmutableSet.of((Object)importedPerson.getPerson().getId()));
    }
}

