/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Strings;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;

@ParametersAreNonnullByDefault
public class InternalLDAPSearchContext {
    private final LdapTemplate _ldapTemplate;
    private final List<String> _baseDNs;
    private final Filter _filter;
    private final SearchControls _searchControl;
    private final int _pageSize;
    private final ExternalIdField _externalIdField;
    private final boolean _pagingEnabled;

    public InternalLDAPSearchContext(LdapTemplate ldapTemplate, List<String> baseDNs, @Nullable Filter filter, SearchControls searchControl, int pageSize, ExternalIdField externalIdField, boolean pagingEnabled) {
        this._ldapTemplate = ldapTemplate;
        this._baseDNs = baseDNs;
        this._filter = filter;
        this._searchControl = searchControl;
        this._pageSize = pageSize;
        this._externalIdField = externalIdField;
        this._pagingEnabled = pagingEnabled;
    }

    @Nonnull
    public InternalLDAPSearchContext withFilter(@Nullable Filter filter) {
        return new InternalLDAPSearchContext(this._ldapTemplate, this._baseDNs, filter, this._searchControl, this._pageSize, this._externalIdField, this._pagingEnabled);
    }

    @Nonnull
    public static InternalLDAPSearchContext createFrom(LDAPSearchContext searchContext) {
        HardcodedFilter filter = Strings.isNullOrEmpty((String)searchContext.getFilter()) ? null : new HardcodedFilter(searchContext.getFilter());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchContext.getSearchScope());
        controls.setReturningAttributes(new String[]{"*", "+"});
        return new InternalLDAPSearchContext(searchContext.getLdapTemplate(), searchContext.getBaseDNList(), (Filter)filter, controls, searchContext.getPageSize(), searchContext.getExternalIdField(), searchContext.isPagingEnabled());
    }

    @Nonnull
    public LdapTemplate getLdapTemplate() {
        return this._ldapTemplate;
    }

    @Nonnull
    public List<String> getBaseDNs() {
        return this._baseDNs;
    }

    @CheckForNull
    public Filter getFilter() {
        return this._filter;
    }

    @Nonnull
    public SearchControls getSearchControl() {
        return this._searchControl;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    @Nonnull
    public ExternalIdField getExternalIdField() {
        return this._externalIdField;
    }

    public boolean isPagingEnabled() {
        return this._pagingEnabled;
    }
}

