/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.impl.PersonImportServiceImpl;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class GenericPersonImportDataProvider
implements PersonImportServiceImpl.PersonImportDataProvider<GenericPersonImportModel> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPersonImportDataProvider.class);
    private static final String DELIMITER = "@#@";
    private final GenericPersonImportModel _personImportModel;
    private final Set<String> _processedFieldNames;

    public GenericPersonImportDataProvider(String externalId, Map<String, String> staticAttributes, ListMultimap<String, String> dynamicAttributes) {
        this(externalId, staticAttributes, dynamicAttributes, (ImmutableSet<String>)ImmutableSet.of(), null, (List<UserGroupId>)ImmutableList.of(), (List<UserGroupId>)ImmutableList.of());
    }

    public GenericPersonImportDataProvider(String externalId, Map<String, String> staticAttributes, ListMultimap<String, String> dynamicAttributes, ImmutableSet<String> roles, @Nullable Boolean blockUser, List<UserGroupId> addedUserGroupMemberships, List<UserGroupId> removedUserGroupMemberships) {
        ArrayListMultimap personImportData = ArrayListMultimap.create();
        this.addMappedStaticFields(staticAttributes, (ListMultimap<String, String>)personImportData, "person.");
        this.addMappedDynamicFields(dynamicAttributes, (ListMultimap<String, String>)personImportData, "person.dynamic.");
        if (blockUser != null) {
            personImportData.put((Object)"person.blocked", (Object)String.valueOf(blockUser));
        }
        this._personImportModel = new GenericPersonImportModel(externalId, (ListMultimap<String, String>)personImportData, roles, blockUser);
        this._processedFieldNames = personImportData.keySet();
        this._personImportModel.setAddedUserGroupMemberships(addedUserGroupMemberships);
        this._personImportModel.setRemovedUserGroupMemberships(removedUserGroupMemberships);
        Properties properties = new Properties();
        properties.setProperty("multiValueSeparator", DELIMITER);
        dynamicAttributes.keySet().forEach(key -> this._personImportModel.addFieldParameters("person.dynamic." + key, properties));
        this.mapPersonDataToModel((ListMultimap<String, String>)personImportData);
    }

    @CheckForNull
    private String normalizeValue(@Nullable String value) {
        return StringUtils.stripToNull((String)value);
    }

    private void addMappedStaticFields(Map<String, String> sourceFields, ListMultimap<String, String> destinationFields, String fieldNamePrefix) {
        sourceFields.forEach((key, value) -> destinationFields.put((Object)(fieldNamePrefix + key), (Object)this.normalizeValue((String)value)));
    }

    private void addMappedDynamicFields(ListMultimap<String, String> sourceFields, ListMultimap<String, String> destinationFields, String fieldNamePrefix) {
        Set keySet = sourceFields.keySet();
        keySet.forEach(key -> {
            List values = sourceFields.get(key);
            String valueString = values.stream().map(this::normalizeValue).filter(Objects::nonNull).collect(Collectors.joining(DELIMITER));
            destinationFields.put((Object)(fieldNamePrefix + key), (Object)this.normalizeValue(valueString));
        });
    }

    private void mapPersonDataToModel(ListMultimap<String, String> personImportData) {
        personImportData.forEach((key, value) -> this._personImportModel.getImportedValues().put(key, value));
        List passwords = personImportData.get((Object)"person.password");
        if (!passwords.isEmpty()) {
            this._personImportModel.setPlainPassword((String)passwords.get(0));
        }
    }

    @Override
    public Iterable<List<GenericPersonImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        statistics.incProcessed(1);
        return ImmutableList.of((Object)ImmutableList.of((Object)this._personImportModel));
    }

    @Override
    public Set<String> getImportedFieldNames() throws ImportException {
        return this._processedFieldNames;
    }
}

