/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.integration.business.PersonExternalIdService;
import de.justsoftware.onx.integration.shared.model.ExternalPersonId;
import de.justsoftware.onx.integration.shared.model.ExternalSystemId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ExternalIdentificationPersonImportProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    private boolean _exclusive = true;
    private ExternalSystemId _systemId;
    private ExternalIdentificationImportDataProvider<I> _importDataProvider;
    private final PersonExternalIdService _personExternalIdService;

    @Autowired
    public ExternalIdentificationPersonImportProcessor(@Nonnull PersonExternalIdService personExternalIdService) {
        this._personExternalIdService = personExternalIdService;
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    @Required
    public void setExternalSystemId(@Nonnull String systemId) {
        this._systemId = new ExternalSystemId(systemId);
    }

    @Required
    public void setImportDataProvider(@Nonnull ExternalIdentificationImportDataProvider<I> importDataProvider) {
        this._importDataProvider = importDataProvider;
    }

    @Override
    public void process(List<? extends I> importModels, ImportUpdateEventCollector importUpdateEventCollector) {
        Set importedPersonIds = importModels.stream().map(PersonImportModel.TO_PERSON_ID).collect(Collectors.toSet());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (ExternalIdImportModel externalIdImportModel : this._importDataProvider.getAdditionalImportDataFor(importModels)) {
                builder.put((Object)externalIdImportModel._personId, (Object)externalIdImportModel._externalId);
            }
            ImmutableMap importedExternalIds = builder.build();
            for (PersonId personId : importedPersonIds) {
                ExternalPersonId externalPersonId = (ExternalPersonId)importedExternalIds.get((Object)personId);
                if (externalPersonId != null) {
                    this._personExternalIdService.setExternalPersonId(personId, externalPersonId, this._systemId, true);
                    continue;
                }
                if (!this._exclusive) continue;
                this._personExternalIdService.removeExternalPersonId(personId, this._systemId);
            }
        }
        catch (ImportException e) {
            PersonImportService.IMPORT_LOG.error("Error occurred during import of external ids. Import aborted for this chunk.", (Throwable)e);
        }
    }

    public static class ExternalIdImportModel {
        private final PersonId _personId;
        private final ExternalPersonId _externalId;

        public ExternalIdImportModel(@Nonnull PersonId personId, @Nonnull ExternalPersonId externalId) {
            this._personId = personId;
            this._externalId = externalId;
        }
    }

    public static interface ExternalIdentificationImportDataProvider<J extends PersonImportModel<?>>
    extends ImportProcessor.ImportDataProvider<J, ExternalIdImportModel> {
    }
}

