/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowImportService;
import de.justsoftware.onx.container.shared.model.AdminRoleForEntitiesException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.MembershipImportService;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.AbstractImportServiceImpl;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class EntityRoleMembershipImportServiceImpl
extends AbstractImportServiceImpl<MembershipImportModel>
implements MembershipImportService {
    @Autowired
    private EntityMemberWorkflowImportService _entityMemberWorkflowService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    private EntityMemberRole _memberRole;
    private MembershipImportService.MembershipImportDataProvider _dataProvider;
    private boolean _onAdminChangeMakeOldAdminCoAdmin = true;
    private ImmutableSet<EntityType> _overrideMembershipForEntityTypes = ImmutableSet.of();

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityRoleMembershipImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, ImportProcessLockService importProcessLockService) {
        super(personService, updateEventHandler, eventBus, clock, importResultMailService, importProcessLockService);
    }

    @Required
    public void setImportDataProvider(MembershipImportService.MembershipImportDataProvider dataProvider) {
        this._dataProvider = dataProvider;
    }

    @Required
    public void setMemberRole(@Nonnull EntityMemberRole memberRole) {
        this._memberRole = memberRole;
    }

    public void setOnAdminChangeMakeOldAdminCoAdmin(boolean onAdminChangeMakeOldAdminCoAdmin) {
        this._onAdminChangeMakeOldAdminCoAdmin = onAdminChangeMakeOldAdminCoAdmin;
    }

    public void setOverrideMembershipForEntityTypes(List<String> overrideMembershipForEntityTypes) {
        this._overrideMembershipForEntityTypes = ImmutableSet.copyOf((Collection)Lists.transform(overrideMembershipForEntityTypes, EntityType.FROM_NAME));
    }

    @Override
    @Nonnull
    protected Iterable<List<MembershipImportModel>> getImportModels(ImportStatistics importStatistics) throws ImportException {
        return this._dataProvider.getImportModels(importStatistics);
    }

    @Override
    public final void importMemberships() throws ImportException {
        this._importProcessLockService.acquireAndExecute(() -> this.doImport());
    }

    @Override
    @Nonnull
    public List<MembershipImportModel> processBatch(List<? extends MembershipImportModel> importModels, ImportStatistics statistics, ImportUpdateEventCollector eventCollector) {
        ArrayList toPostProcess = Lists.newArrayList();
        HashMultimap importedMemberships = HashMultimap.create();
        HashSet importedEntityIds = Sets.newHashSet();
        for (MembershipImportModel membershipImportModel : importModels) {
            importedEntityIds.addAll(membershipImportModel.getEntityIds());
            importedMemberships.putAll(membershipImportModel.getMembershipsByEntityId());
        }
        this._memberRole.accept(new RoleSpecificMembershipImportProcessor(importedEntityIds, (SetMultimap<EntityId, PersonId>)importedMemberships, statistics, eventCollector));
        return toPostProcess;
    }

    @Override
    protected void initBeforeImport() {
    }

    @Override
    protected void cleanUpAfterImport() {
    }

    private final class RoleSpecificMembershipImportProcessor
    extends EntityMemberRole.DefaultVisitor<Object> {
        private final SetMultimap<EntityId, PersonId> _importedMemberships;
        private final Set<EntityId> _importedEntityIds;
        private final ImportStatistics _statistics;
        private final ServerEventCollector _eventCollector;

        private RoleSpecificMembershipImportProcessor(@Nonnull Set<EntityId> importedEntityIds, @Nonnull SetMultimap<EntityId, PersonId> importedMemberships, @Nonnull ImportStatistics statistics, ServerEventCollector eventCollector) {
            this._importedEntityIds = importedEntityIds;
            this._importedMemberships = importedMemberships;
            this._statistics = statistics;
            this._eventCollector = eventCollector;
        }

        @Override
        public Object visitAdmin() {
            MemberChangeOptions adminChangeOptions = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).setMakeOldAdminCoAdmin(EntityRoleMembershipImportServiceImpl.this._onAdminChangeMakeOldAdminCoAdmin).build();
            for (EntityId entityId : this._importedEntityIds) {
                Set importedAdminIds = this._importedMemberships.get((Object)entityId);
                if (CollectionUtils.isEmpty((Collection)importedAdminIds)) {
                    PersonId adminId;
                    EntityMember admin = EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.getAdmin(entityId);
                    PersonId personId = adminId = admin != null ? admin.getPersonId() : null;
                    if (adminId == null) {
                        PersonImportService.IMPORT_LOG.error("No admin imported for entity id {}, but current admin is not present!", (Object)entityId);
                        this._statistics.incFailed();
                        continue;
                    }
                    try {
                        PersonImportService.IMPORT_LOG.warn("No admin imported for entity id {}, so current admin with id {} is removed, admin role will be transferred to default.", (Object)entityId, (Object)adminId);
                        EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.transferAdminRightsToDefaultAdmin(entityId, adminId, adminChangeOptions);
                        this._statistics.incUpdated();
                    }
                    catch (AdminRoleForEntitiesException e) {
                        this._statistics.incFailed();
                        PersonImportService.IMPORT_LOG.error("Failed to remove current admin with id {} from entity id {}.", (Object)adminId, (Object)entityId);
                    }
                    catch (Exception e) {
                        this._statistics.incFailed();
                        PersonImportService.IMPORT_LOG.error(String.format("Failed to remove admin for entity %1$s", entityId), (Throwable)e);
                    }
                    continue;
                }
                if (importedAdminIds.size() > 1) {
                    PersonImportService.IMPORT_LOG.warn("Retrieved more than one admin for entity id {}, using first person of retrieved {}.", (Object)entityId, (Object)importedAdminIds);
                }
                PersonId newAdminId = (PersonId)importedAdminIds.iterator().next();
                try {
                    PersonImportService.IMPORT_LOG.info("Membership import: Set admin of entity " + entityId + " to person with id " + newAdminId);
                    EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.grantMemberToAdmin(entityId, newAdminId, adminChangeOptions);
                    this._statistics.incUpdated();
                }
                catch (Exception e) {
                    this._statistics.incFailed();
                    PersonImportService.IMPORT_LOG.error(String.format("Failed to set admin for entity %1$s for person ids %2$s", entityId, newAdminId), (Throwable)e);
                }
            }
            return this;
        }

        @Override
        public Object visitCoAdmin() {
            MemberChangeOptions coAdminChangeOptions = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).build();
            for (EntityId entityId : this._importedEntityIds) {
                Set memberIds = this._importedMemberships.get((Object)entityId);
                HashSet importedCoAdminIds = CollectionUtils.isEmpty((Collection)memberIds) ? Sets.newHashSet() : Sets.newHashSet((Iterable)memberIds);
                try {
                    Iterable<EntityMemberWithPerson> coAdminMembers = EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.getDirectCoAdmins(entityId);
                    PersonImportService.IMPORT_LOG.info("Membership import: Adding co-admins to entity " + entityId + ": " + importedCoAdminIds);
                    for (PersonId coAdminId : importedCoAdminIds) {
                        try {
                            EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.grantMembersToCoAdmin(entityId, (Set<PersonId>)ImmutableSet.of((Object)coAdminId), coAdminChangeOptions);
                        }
                        catch (ServiceException e) {
                            PersonImportService.IMPORT_LOG.error(String.format("Failed to add co-admin role to entity %1$s for person id %2$s", entityId, coAdminId), (Throwable)e);
                        }
                    }
                    Iterable coAdminsToRemove = Iterables.filter(coAdminMembers, (Predicate)Predicates.not((Predicate)Predicates.compose((Predicate)Predicates.in((Collection)importedCoAdminIds), EntityMember.GET_PERSON_ID)));
                    if (!Iterables.isEmpty((Iterable)coAdminsToRemove)) {
                        PersonImportService.IMPORT_LOG.info("Membership import: Removing co-admins from entity " + entityId + ": " + Iterables.transform((Iterable)coAdminsToRemove, EntityMember.GET_PERSON_ID));
                    }
                    for (EntityMember coAdminMember : coAdminsToRemove) {
                        EntityRoleMembershipImportServiceImpl.this._entityAdministrationService.deleteCoAdmins(coAdminMember.getEntityId(), (ImmutableSet<PersonId>)ImmutableSet.of((Object)coAdminMember.getPersonId()));
                    }
                    this._statistics.incUpdated();
                }
                catch (Exception e) {
                    PersonImportService.IMPORT_LOG.error(String.format("Failed to add co-admin role to entity %1$s for person ids %2$s", entityId, importedCoAdminIds), (Throwable)e);
                    this._statistics.incFailed();
                }
            }
            return this;
        }

        @Override
        public Object visitMember() {
            MemberChangeOptions noNotificationOptions = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).setMakeOldAdminCoAdmin(false).setUpdateSubscriptions(false).build();
            this.addMemberships(noNotificationOptions);
            this.removeMemberships(noNotificationOptions);
            return this;
        }

        private void addMemberships(@Nonnull MemberChangeOptions options) {
            for (EntityId entityId : this._importedEntityIds) {
                Set memberIds = this._importedMemberships.get((Object)entityId);
                if (CollectionUtils.isEmpty((Collection)memberIds)) continue;
                try {
                    PersonImportService.IMPORT_LOG.info("Membership import: Adding members to entity " + entityId + ": " + memberIds);
                    EntityRoleMembershipImportServiceImpl.this._entityMemberWorkflowService.addMembers(entityId, memberIds, options, this._eventCollector);
                    this._statistics.incInserted();
                }
                catch (ServiceException | DAOException e) {
                    this._statistics.incFailed();
                    PersonImportService.IMPORT_LOG.error(String.format("Failed to add members to entity %1$s for person ids %2$s", entityId, memberIds), (Throwable)e);
                }
            }
        }

        private void removeMemberships(@Nonnull MemberChangeOptions options) {
            ImmutableSetMultimap<EntityId, PersonId> dbMembers;
            if (EntityRoleMembershipImportServiceImpl.this._overrideMembershipForEntityTypes.isEmpty() || this._importedEntityIds.isEmpty()) {
                return;
            }
            try {
                dbMembers = EntityRoleMembershipImportServiceImpl.this._entityMemberWorkflowService.getEntityMembersByEntityTypesAndEntityIdsAndRoles((Set<EntityType>)EntityRoleMembershipImportServiceImpl.this._overrideMembershipForEntityTypes, this._importedEntityIds, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER));
            }
            catch (ServiceException | DAOException e) {
                PersonImportService.IMPORT_LOG.error("Could not retrieve memberships by ids and roles", (Throwable)e);
                this._statistics.incFailed();
                return;
            }
            for (EntityId importedEntityId : this._importedEntityIds) {
                Sets.SetView membersToRemove = Sets.difference((Set)dbMembers.get((Object)importedEntityId), (Set)this._importedMemberships.get((Object)importedEntityId));
                if (membersToRemove.isEmpty()) continue;
                try {
                    PersonImportService.IMPORT_LOG.info("Removing members {} from entity id {}", (Object)membersToRemove, (Object)importedEntityId);
                    EntityRoleMembershipImportServiceImpl.this._entityMemberWorkflowService.removeMembers(importedEntityId, (Set<PersonId>)membersToRemove, options, this._eventCollector);
                    this._statistics.incUpdated();
                }
                catch (ServiceException | DAOException e) {
                    PersonImportService.IMPORT_LOG.error("Could not remove members from entity id " + importedEntityId, (Throwable)e);
                    this._statistics.incFailed();
                }
            }
        }

        @Override
        protected Object getDefault() {
            return this;
        }
    }
}

