/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityReadDataService;
import de.justsoftware.onx.container.business.EntityVersionImportService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.EntityImportInformationService;
import de.justsoftware.onx.migration.business.EntityImportReviewHelper;
import de.justsoftware.onx.migration.business.EntityImportService;
import de.justsoftware.onx.migration.business.EntityRemovalService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.impl.EntityImportReviewHelperImpl;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class EntityRemovalServiceImpl
implements EntityRemovalService {
    @Autowired
    private Settings _settings;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private EntityVersionImportService _entityVersionService;
    @Autowired
    private EntityReadDataService _entityReadDataService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private PersonReadDataService _personReadDataService;
    @Autowired
    private EntityImportInformationService _entityImportInformationService;
    @Autowired
    private Clock _clock;
    @Autowired
    private ImportResultMailService _mailService;
    @Autowired
    @Qualifier(value="importTenantIdSupplier")
    private Supplier<TenantId> _importTenantIdSupplier;
    private PersonId _entityVersionAuthor;
    private ImmutableList<PersonId> _reviewers = ImmutableList.of();

    @Required
    public void setEntityVersionAuthor(long entityVersionAuthor) {
        this._entityVersionAuthor = new PersonId(entityVersionAuthor);
    }

    @Required
    public void setReviewers(List<Long> reviewers) {
        this._reviewers = ImmutableList.copyOf((Iterable)Iterables.transform(reviewers, PersonId.FROM_LONG));
    }

    @Override
    public void removeEntities() throws ImportException {
        EntityImportService.IMPORT_LOG.info("****** ENTITY REMOVAL PROCESS STARTED *********");
        try {
            Set<EntityType> importedEntityTypes = this._entityImportInformationService.getImportedEntityTypes();
            for (EntityType entityType : importedEntityTypes) {
                this.checkAndRemoveEntitiesOfType(entityType);
            }
        }
        catch (ImportException e) {
            EntityImportService.IMPORT_LOG.error("Error while fetching entity information from import source", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            EntityImportService.IMPORT_LOG.error("Unexpected error while processing removed entities", (Throwable)e);
            throw new ImportException("Unexpected error while processing removed entities", e);
        }
        finally {
            EntityImportService.IMPORT_LOG.info("****** ENTITY REMOVAL PROCESS FINISHED *********");
        }
    }

    private void checkAndRemoveEntitiesOfType(EntityType entityType) throws ImportException {
        EntityImportReviewHelper helper = this.initReviewTriggerHelper(entityType);
        if (!helper.isReviewTriggerEnabled()) {
            EntityImportService.IMPORT_LOG.error("Release process cannot be started for entity type " + entityType + ". Please check release process configuration.");
            return;
        }
        ImmutableMap<EntityId, EntityVersion> entityIdsToCheck = this.getEntityIdsToCheck(entityType, helper);
        EntityImportService.IMPORT_LOG.info("Number of non-archived entities of imported type to check for removal: " + entityIdsToCheck.size());
        Set<EntityId> foundEntityIds = this._entityImportInformationService.findEntitiesInImportSource((Set<EntityId>)entityIdsToCheck.keySet());
        HashSet entityIdsNotFoundInImportSource = Sets.newHashSet((Iterable)entityIdsToCheck.keySet());
        entityIdsNotFoundInImportSource.removeAll(foundEntityIds);
        EntityImportService.IMPORT_LOG.info("Number of entities not found in import source: " + entityIdsNotFoundInImportSource.size());
        for (EntityId entityId : entityIdsNotFoundInImportSource) {
            EntityVersion entityVersion = (EntityVersion)entityIdsToCheck.get((Object)entityId);
            if (helper.isEntityInReview(entityVersion)) {
                EntityImportService.IMPORT_LOG.error("Failed to handle entity removed from import source with id " + entityId + ": review process already in progress");
                continue;
            }
            try {
                this.handleDeletedEntity(entityId, entityVersion, entityType, helper);
            }
            catch (RuntimeException e) {
                EntityImportService.IMPORT_LOG.error("Failed to handle entity removed from import source with id " + entityId, (Throwable)e);
            }
        }
    }

    @Nonnull
    private ImmutableMap<EntityId, EntityVersion> getEntityIdsToCheck(EntityType entityType, EntityImportReviewHelper helper) {
        ImmutableSetMultimap<EntityType, EntityId> idsByTypes = this._entityReadDataService.getIdsByTypes((Iterable<EntityType>)ImmutableSet.of((Object)entityType));
        ImmutableMap<EntityId, EntityVersion> entityVersions = this._entityVersionService.getNewestVersion((Set<EntityId>)ImmutableSet.copyOf((Collection)idsByTypes.values()));
        ImmutableMap.Builder entityVersionsNotArchived = ImmutableMap.builder();
        for (EntityVersion entityVersion : entityVersions.values()) {
            if (helper.isEntityArchived(entityVersion)) continue;
            entityVersionsNotArchived.put((Object)entityVersion.getEntityId(), (Object)entityVersion);
        }
        return entityVersionsNotArchived.build();
    }

    private void handleDeletedEntity(EntityId entityId, EntityVersion currentVersion, EntityType entityType, EntityImportReviewHelper helper) {
        EntityVersionReleaseClientModel data = helper.createVersionReleaseModel(entityType, currentVersion);
        EverythingAllowedAuthorizationCheckContextWithUserId auth = new EverythingAllowedAuthorizationCheckContextWithUserId(currentVersion.getAuthorId(), (TenantId)this._importTenantIdSupplier.get(), this._settings.defaultLanguage());
        EntityVersion stagedVersion = this._entityVersionService.stageVersionForReview(data, auth, false);
        EntityImportService.IMPORT_LOG.info("started release process for removed entity with id " + entityId + ", version " + stagedVersion.toString());
    }

    @Nonnull
    private EntityImportReviewHelper initReviewTriggerHelper(EntityType entityType) {
        EntityVersionConstants entityVersionConstants = this._i18nService.createProxy(EntityVersionConstants.class, this._settings.defaultLanguage());
        String changeMessage = entityVersionConstants.changeMessageByImportRemoval();
        String commentForReviewer = entityVersionConstants.commentForReviewerByImportRemoval();
        if (!this._entityConfigService.releaseProcessMandatory(entityType)) {
            EntityImportService.IMPORT_LOG.info("Release process is not activated for imported type " + entityType + ".");
            return EntityImportReviewHelper.DISABLED;
        }
        if (this._entityVersionAuthor == null) {
            EntityImportService.IMPORT_LOG.error("No version author provided. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        DBPerson versionAuthor = this._personReadDataService.getPersonById(this._entityVersionAuthor);
        if (versionAuthor == null) {
            EntityImportService.IMPORT_LOG.error("The provided version author (" + this._entityVersionAuthor + ") does not exist. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        if (this._reviewers == null || this._reviewers.isEmpty()) {
            EntityImportService.IMPORT_LOG.error("No reviewers provided. No releases process will be triggered.");
            return EntityImportReviewHelper.DISABLED;
        }
        return new EntityImportReviewHelperImpl(this._entityVersionAuthor, this._reviewers, commentForReviewer, changeMessage, this._entityConfigService, new EntityImportReviewHelper.EntityVersionAccess(){

            @Override
            public EntityVersion getLastPublicVersionBefore(EntityVersionId versionId) {
                return EntityRemovalServiceImpl.this._entityVersionService.getLastPublicVersionBefore(versionId);
            }
        }, this._clock);
    }

    @Override
    public ImportStatistics doImport() {
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        try {
            this.removeEntities();
        }
        catch (ImportException e) {
            statistics.incFailedImports();
            this._mailService.notifyImportFailed(e.getMessage());
        }
        return statistics;
    }
}

