/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.migration.business.EntityImportReviewHelper;
import de.justsoftware.onx.migration.business.EntityImportService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityImportReviewHelperImpl
implements EntityImportReviewHelper {
    private final PersonId _entityVersionAuthor;
    private final ImmutableList<PersonId> _reviewers;
    private final String _commentForReviewer;
    private final String _changeMessage;
    private final EntityConfigService _entityConfigService;
    private final EntityImportReviewHelper.EntityVersionAccess _entityVersionAccess;
    private final Clock _clock;

    public EntityImportReviewHelperImpl(PersonId versionAuthor, ImmutableList<PersonId> reviewers, String commentForReviewer, String changeMessage, EntityConfigService entityConfigService, EntityImportReviewHelper.EntityVersionAccess entityVersionAccess, Clock clock) {
        this._entityVersionAuthor = versionAuthor;
        this._reviewers = reviewers;
        this._commentForReviewer = commentForReviewer;
        this._changeMessage = changeMessage;
        this._entityConfigService = entityConfigService;
        this._entityVersionAccess = entityVersionAccess;
        this._clock = clock;
    }

    @Override
    public boolean isReviewTriggerEnabled() {
        return true;
    }

    @Override
    public EntityVersionReleaseClientModel createVersionReleaseModel(EntityType entityType, EntityVersion version) {
        EntityId entityId = version.getEntityId();
        String commentForReviewer = this.getValidCommentForReviewer(entityId, entityType, this._commentForReviewer);
        String changeMessage = this.getValidChangeMessage(entityId, entityType, this._changeMessage);
        DateWithoutTimezone expirationDate = this.getValidExpirationDate(entityType);
        EntityVersionReleaseClientModel releaseData = new EntityVersionReleaseClientModel(this._entityVersionAuthor, version.getId(), EntityVersionType.MAJOR, (List<PersonId>)this._reviewers, changeMessage, commentForReviewer, null, expirationDate);
        return releaseData;
    }

    @Override
    public boolean isEntityArchived(EntityVersion entityVersion) {
        if (entityVersion == null) {
            return false;
        }
        EntityStatus status = entityVersion.getStatus();
        ReleaseProcessStatus staticStatus = ReleaseProcessStatus.fromStatusIfExists(status);
        if (staticStatus != null) {
            switch (staticStatus) {
                case ARCHIVED: {
                    return true;
                }
                case DECLINED: 
                case DRAFT: {
                    EntityVersion lastPublicVersion = this._entityVersionAccess.getLastPublicVersionBefore(entityVersion.getId());
                    return lastPublicVersion != null && lastPublicVersion.getStatus().isArchived();
                }
                case IN_REVIEW: 
                case PUBLISHED: 
                case RELEASED: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEntityInReview(EntityVersion entityVersion) {
        if (entityVersion == null) {
            return false;
        }
        return ReleaseProcessStatus.IN_REVIEW.equals((Object)ReleaseProcessStatus.fromStatusIfExists(entityVersion.getStatus()));
    }

    @CheckForNull
    private DateWithoutTimezone getValidExpirationDate(EntityType entityType) {
        if (this._entityConfigService.maxDaysAsActiveVersion(entityType) == 0) {
            return null;
        }
        return new DateWithoutTimezone(this._clock.now().plusHours(1).getMillis());
    }

    @CheckForNull
    private String getValidCommentForReviewer(EntityId entityId, EntityType entityType, String commentForReviewer) {
        EntityVersionReleaseDataOption commentConfig = this._entityConfigService.getReleaseCommentForReviewerVisibility(entityType);
        if (commentConfig == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            if (!StringUtil.isBlank(commentForReviewer)) {
                EntityImportService.IMPORT_LOG.warn("Ignored configured comment for reviewer for release of entity " + entityId.getId() + " since comments for reviewers are disabled for entity type " + entityType + ".");
            }
            return null;
        }
        if (commentForReviewer.trim().length() > 250) {
            EntityImportService.IMPORT_LOG.warn("Ignored configured comment for reviewer for release of entity " + entityId.getId() + " since it exceeds the maximum length of 250 characters.");
            return null;
        }
        return commentForReviewer;
    }

    @CheckForNull
    private String getValidChangeMessage(EntityId entityId, EntityType entityType, String changeMessage) {
        EntityVersionReleaseDataOption changeMessageConfig = this._entityConfigService.getReleaseChangeMessageVisibility(entityType);
        if (changeMessageConfig == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            if (!StringUtil.isBlank(changeMessage)) {
                EntityImportService.IMPORT_LOG.warn("Ignored configured change message for release of entity " + entityId.getId() + " since change messages are disabled for entity type " + entityType + ".");
            }
            return null;
        }
        if (changeMessage.trim().length() > 500) {
            EntityImportService.IMPORT_LOG.warn("Ignored configured change message for release of entity " + entityId.getId() + " since it exceeds the maximum length of 500 characters.");
            return null;
        }
        return changeMessage;
    }

    @Override
    @Nonnull
    public PersonId getEntityVersionAuthor() {
        return this._entityVersionAuthor;
    }
}

