/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.util.Verification;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.ImportPreProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class EmailAddressImportPreProcessor
implements ImportPreProcessor<PersonImportModel<?>> {
    private String _emailPrefix;
    private String _emailDomain;
    private final PersonService _personService;
    private final PersonImportMappingDAO _importDAO;

    @Autowired
    public EmailAddressImportPreProcessor(PersonService personService, PersonImportMappingDAO importDao) {
        this._personService = personService;
        this._importDAO = importDao;
    }

    @Required
    public void setEmailPrefix(String emailPrefix) {
        this._emailPrefix = emailPrefix;
    }

    @Required
    public void setEmailDomain(String emailDomain) {
        this._emailDomain = emailDomain;
    }

    @Override
    public void process(List<? extends PersonImportModel<?>> importResult) {
        for (PersonImportModel<?> personImportModel : importResult) {
            this.processSingleModel(personImportModel);
        }
    }

    private void processSingleModel(PersonImportModel<?> importResult) {
        String importedEmail;
        List importedEmails = importResult.getImportedValues().get((Object)"person.email");
        String string = importedEmail = importedEmails != null ? (String)Iterables.getFirst((Iterable)importedEmails, null) : null;
        if (importedEmail == null) {
            String externalId = importResult.accept(GetIdForEmailGenerationVisitor.INSTANCE);
            if (!Strings.isNullOrEmpty((String)externalId)) {
                String email = this.getSavedEmailAddress(externalId);
                if (email == null) {
                    String generatedEmail = this.generateEmailAddress(externalId);
                    if (Verification.verifyEmail(generatedEmail)) {
                        email = generatedEmail;
                    } else {
                        PersonImportService.IMPORT_LOG.warn("Generated email {} for user {} is not valid. Skipping email assignment.", (Object)generatedEmail, (Object)externalId);
                    }
                }
                importResult.getImportedValues().replaceValues((Object)"person.email", (Iterable)Lists.newArrayList((Object[])new String[]{email}));
                importResult.addPreProcessedFieldName("person.email");
                PersonImportService.IMPORT_LOG.info("Assigning email address {} for user {}", (Object)email, (Object)externalId);
            } else {
                PersonImportService.IMPORT_LOG.warn("The imported profile {} does not have an external id. Skipping email assignment.", (Object)importResult.getPerson().getFullName());
            }
        }
    }

    @CheckForNull
    private String getSavedEmailAddress(String externalId) {
        PersonId personId = this._importDAO.getInternalId(externalId);
        if (personId != null) {
            DBPerson dbPerson = this._personService.getPersonById(personId);
            return dbPerson != null ? dbPerson.getEmail() : null;
        }
        return null;
    }

    @Nonnull
    private String generateEmailAddress(String externalId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this._emailPrefix).append(externalId).append("@").append(this._emailDomain);
        return builder.toString();
    }

    private static enum GetIdForEmailGenerationVisitor implements PersonImportModelVisitor<String>
    {
        INSTANCE;


        @Override
        public String visitCSVPersonImportModel(CSVPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
            return importModel.getExternalIdWithoutDomain();
        }

        @Override
        public String visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitGenericPersonImportModel(GenericPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }
    }
}

