/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapRdn;
import org.springframework.stereotype.Service;

@Service(value="domainResolver")
public class DomainResolver {
    @CheckForNull
    private final String _defaultDomain;

    public DomainResolver() {
        this(null);
    }

    public DomainResolver(@Nullable String defaultDomain) {
        this._defaultDomain = defaultDomain;
    }

    @Nonnull
    public Domain getDomain(@Nonnull Name distinguishedName) throws InvalidNameException {
        if (this._defaultDomain != null) {
            return new Domain(this._defaultDomain);
        }
        DistinguishedName dn = distinguishedName instanceof DistinguishedName ? (DistinguishedName)distinguishedName : DistinguishedName.immutableDistinguishedName((String)distinguishedName.toString());
        List names = dn.getNames();
        ArrayList domain = Lists.newArrayList();
        for (LdapRdn ldaprdn : names) {
            if (!ldaprdn.getKey().equalsIgnoreCase("dc")) continue;
            domain.add(ldaprdn.getValue());
        }
        if (!domain.isEmpty()) {
            return new Domain(Joiner.on((char)'.').skipNulls().join((Iterable)Lists.reverse((List)domain)));
        }
        throw new InvalidNameException("Failed to extract domain from dn: No domain part found in dn " + distinguishedName);
    }

    @Nonnull
    public Domain getDomain(@Nonnull String domain) {
        if (this._defaultDomain != null) {
            return new Domain(this._defaultDomain);
        }
        return new Domain(domain);
    }

    public static final class Domain {
        @Nonnull
        private final String _name;

        private Domain(@Nonnull String domainName) {
            this._name = domainName;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }
    }
}

