/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatePersonImportModelVisitor
implements PersonImportModelVisitor<DateTime> {
    private static final Logger IMPORT_LOG = LoggerFactory.getLogger((String)"IMPORTLOG");
    private final String _dateFieldName;
    private final DateTimeFormatter _dateFormat;

    public DatePersonImportModelVisitor(@Nonnull String dateFieldName, @Nonnull String dateFormat) {
        this._dateFieldName = dateFieldName;
        this._dateFormat = DateTimeFormat.forPattern((String)dateFormat);
    }

    @Override
    public DateTime visitCSVPersonImportModel(CSVPersonImportModel importModel) {
        Map<String, String> row = importModel.getRow();
        return row == null ? null : this.parseModifyDate(row.get(this._dateFieldName));
    }

    @Override
    public DateTime visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
        Attribute attribute = importModel.getAttributes().get(this._dateFieldName);
        if (attribute == null) {
            return null;
        }
        String timestamp = null;
        try {
            timestamp = (String)attribute.get();
        }
        catch (NamingException e) {
            IMPORT_LOG.error("Could not get modify date for user " + (String)importModel.getExternalId());
        }
        return this.parseModifyDate(timestamp);
    }

    @Override
    public DateTime visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
        String date = (String)importModel.getDataRow().get(this._dateFieldName);
        return this.parseModifyDate(date);
    }

    @Override
    public DateTime visitGenericPersonImportModel(GenericPersonImportModel importModel) {
        String date = importModel.getPersonField(this._dateFieldName);
        return this.parseModifyDate(date);
    }

    @CheckForNull
    private DateTime parseModifyDate(@Nullable String dateText) {
        if (StringUtil.isBlank(dateText)) {
            return null;
        }
        boolean useUTC = dateText.endsWith("Z");
        try {
            if (useUTC) {
                return DateTime.parse((String)dateText, (DateTimeFormatter)this._dateFormat.withZone(DateTimeZone.UTC));
            }
            return DateTime.parse((String)dateText, (DateTimeFormatter)this._dateFormat.withZone(DateTimeZone.getDefault()));
        }
        catch (IllegalArgumentException e) {
            IMPORT_LOG.error("Could not parse date " + dateText);
            return null;
        }
    }
}

