/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.IdMapper;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class CSVMultiValueExtractor<T> {
    private String _csvColumnName;
    private String _csvMultiValueDelimiter = ",";
    private IdMapper<T> _idMapper;

    @Required
    public void setCsvColumnName(@Nonnull String csvColumnName) {
        this._csvColumnName = csvColumnName;
    }

    @Required
    public void setIdMapper(@Nonnull IdMapper<T> idMapper) {
        this._idMapper = idMapper;
    }

    public void setCsvMultiValueDelimiter(@Nonnull String csvMultiValueDelimiter) {
        this._csvMultiValueDelimiter = csvMultiValueDelimiter;
    }

    @Nonnull
    public ImmutableSet<T> getValues(@Nonnull Map<String, String> csvRow) {
        String multiValues = csvRow.get(this._csvColumnName);
        if (StringUtil.isBlank(multiValues)) {
            PersonImportService.IMPORT_LOG.info("No {} values defined. Assigning values not possible.", (Object)this._csvColumnName);
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterable iterable = Splitter.on((String)this._csvMultiValueDelimiter).trimResults().omitEmptyStrings().split((CharSequence)multiValues);
        for (String csvValue : iterable) {
            builder.addAll(this._idMapper.getIdsByExternalKeys(csvValue));
        }
        return builder.build();
    }
}

